from __future__ import absolute_import
from __future__ import division
from __future__ import print_function
import pymysql
import smtplib
from email.mime.text import MIMEText
from email.utils import formataddr
from email.mime.multipart import MIMEMultipart
from email.mime.application import MIMEApplication
import redis
import datetime
from pyspark import SparkConf
import time
from pyspark.sql import SparkSession
import json
import numpy as np
import pandas as pd
from pyspark.sql.functions import lit
from pyspark.sql.functions import concat_ws
from tool import *


def get_hot_search_words_tag():
    try:
        hot_search = """
                        SELECT a.keywords,
                               b.id,
                               b.tag_type
                        FROM api_hot_search_words a
                        LEFT JOIN api_tag b ON a.keywords=b.name
                        WHERE a.is_delete=0
                          AND b.tag_type+0<'4'+0
                          AND b.is_online=1
                        ORDER BY a.sorted DESC LIMIT 10
                        """
        mysql_results = get_data_by_mysql('172.16.30.141', 3306, 'work', 'BJQaT9VzDcuPBqkd', 'zhengxing', hot_search)
        return mysql_results
    except Exception as e:
        print(e)
        return []


def get_user_service_portrait(cl_id, all_word_tags, all_tag_tag_type, all_3tag_2tag, size=10):
    try:
        db_jerry_test = pymysql.connect(host='172.16.40.158', port=4000, user='root', passwd='3SYz54LS9#^9sBvC',
                                        db='jerry_test', charset='utf8')
        cur_jerry_test = db_jerry_test.cursor()
        # # 用户的非搜索、支付、验证的行为
        # user_df_service_sql = "select time,cl_id,score_type,tag_id,tag_referrer,action from user_new_tag_log " \
        #                       "where cl_id ='{}' and action not in " \
        #                       "('api/order/validate','api/settlement/alipay_callback','do_search')".format(cl_id)
        # cur_jerry_test.execute(user_df_service_sql)

        # 用户的非搜索行为
        user_df_service_sql = "select time,cl_id,score_type,tag_id,tag_referrer,action from user_new_tag_log " \
                              "where cl_id ='{}' and action != 'do_search' ".format(cl_id)
        cur_jerry_test.execute(user_df_service_sql)

        data = list(cur_jerry_test.fetchall())
        if data:
            user_df_service = pd.DataFrame(data)
            user_df_service.columns = ["time", "cl_id", "score_type", "tag_id", "tag_referrer", "action"]
        else:
            user_df_service = pd.DataFrame(columns=["time", "cl_id", "score_type", "tag_id", "tag_referrer", "action"])
        # 用户的搜索行为
        user_df_search_sql = "select time,cl_id,score_type,tag_id,tag_referrer,action from user_new_tag_log " \
                             "where cl_id ='{}' and action = 'do_search'".format(cl_id)
        cur_jerry_test.execute(user_df_search_sql)
        data_search = list(cur_jerry_test.fetchall())
        if data_search:
            user_df_search = pd.DataFrame(data_search)
            user_df_search.columns = ["time", "cl_id", "score_type", "tag_id", "tag_referrer", "action"]
        else:
            user_df_search = pd.DataFrame(columns=["time", "cl_id", "score_type", "tag_id", "tag_referrer", "action"])

        # 搜索词转成tag
        # user_df_search_2_tag = pd.DataFrame(columns=list(user_df_service.columns))
        for index, row in user_df_search.iterrows():
            if row['tag_referrer'] in all_word_tags:
                for search_tag in all_word_tags[row['tag_referrer']]:
                    row['tag_id'] = int(search_tag)
                    user_df_service = user_df_service.append(row, ignore_index=True)
                    break

        # 增加df字段(days_diff_now, tag_type, tag2)
        if not user_df_service.empty:
            user_df_service["days_diff_now"] = round((int(time.time()) - user_df_service["time"].astype(float)) / (24 * 60 * 60))
            user_df_service["tag_type"] = user_df_service.apply(lambda x: all_tag_tag_type.get(x["tag_id"]), axis=1)
            user_df_service = user_df_service[user_df_service['tag_type'].isin(['2','3'])]
            user_log_df_tag2_list = user_df_service[user_df_service['tag_type'] == '2']['tag_id'].unique().tolist()
            user_df_service["tag2"] = user_df_service.apply(lambda x:
                                                    get_tag2_from_tag3(x.tag_id, all_3tag_2tag, user_log_df_tag2_list)
                                                    if x.tag_type == '3' else x.tag_id, axis=1)
            user_df_service["tag2_type"] = user_df_service.apply(lambda x: all_tag_tag_type.get(x["tag2"]), axis=1)
            # 算分及比例
            user_df_service["tag_score"] = user_df_service.apply(
                lambda x: compute_henqiang(x.days_diff_now)/get_action_tag_count(user_df_service, x.time) if x.score_type == "henqiang" else (
                    compute_jiaoqiang(x.days_diff_now)/get_action_tag_count(user_df_service, x.time) if x.score_type == "jiaoqiang" else (
                        compute_ai_scan(x.days_diff_now)/get_action_tag_count(user_df_service, x.time) if x.score_type == "ai_scan" else (
                        compute_ruoyixiang(x.days_diff_now)/get_action_tag_count(user_df_service, x.time) if x.score_type == "ruoyixiang" else
                        compute_validate(x.days_diff_now)/get_action_tag_count(user_df_service, x.time)))), axis=1)
            tag_score_sum = user_df_service.groupby(by=["tag2", "tag2_type"]).agg(
                {'tag_score': 'sum', 'cl_id': 'first', 'action': 'first'}).reset_index().sort_values(by=["tag_score"],
                                                                                                     ascending=False)
            tag_score_sum['weight'] = 100 * tag_score_sum['tag_score'] / tag_score_sum['tag_score'].sum()
            tag_score_sum["pay_type"] = tag_score_sum.apply(
                lambda x: 3 if x.action == "api/order/validate" else (
                    2 if x.action == "api/settlement/alipay_callback" else 1
                ), axis=1
            )
            gmkv_tag_score_sum = tag_score_sum[["tag2", "tag_score", "weight"]][:size].to_dict('record')
            # 写gmkv
            gm_kv_cli = redis.Redis(host="172.16.40.135", port=5379, db=2, socket_timeout=2000)
            cl_id_portrait_key = "user:service_portrait_tags:cl_id:" + str(cl_id)
            tag_id_list_json = json.dumps(gmkv_tag_score_sum)
            gm_kv_cli.set(cl_id_portrait_key, tag_id_list_json)
            gm_kv_cli.expire(cl_id_portrait_key, time=30 * 24 * 60 * 60)
            # 写tidb，redis同步
            stat_date = datetime.datetime.today().strftime('%Y-%m-%d')
            replace_sql = """replace into user_service_portrait_tags (stat_date, cl_id, tag_list) values("{stat_date}","{cl_id}","{tag_list}")"""\
                .format(stat_date=stat_date, cl_id=cl_id, tag_list=gmkv_tag_score_sum)
            cur_jerry_test.execute(replace_sql)
            db_jerry_test.commit()
            # 写tidb 用户分层营销
            # todo 不准确，因为聚合后，一个标签会有多个来源，即多个pay_type
            score_result = tag_score_sum[["tag2", "cl_id", "tag_score", "weight", "pay_type"]]
            score_result.rename(columns={"tag2": "tag_id", "cl_id": "device_id", "tag_score": "score"}, inplace=True)
            delete_sql = "delete from api_market_personas where device_id='{}'".format(cl_id)
            cur_jerry_test.execute(delete_sql)
            db_jerry_test.commit()

            for index, row in score_result.iterrows():
                insert_sql = "insert into api_market_personas values (null, {}, '{}', {}, {}, {})".format(
                    row['tag_id'], row['device_id'], row['score'], row['weight'], row['pay_type'])
                cur_jerry_test.execute(insert_sql)
                db_jerry_test.commit()
            db_jerry_test.close()
            return "sucess"
    except Exception as e:
        print(e)


if __name__ == '__main__':
    try:
        db_jerry_test = pymysql.connect(host='172.16.40.170', port=4000, user='root', passwd='3SYz54LS9#^9sBvC',
                                        db='jerry_test', charset='utf8')
        cur_jerry_test = db_jerry_test.cursor()

        # 获取最近30天内的用户设备id
        sql_device_ids = "select distinct cl_id from user_new_tag_log " \
                         "where time > UNIX_TIMESTAMP(DATE_SUB(NOW(), INTERVAL 30 day))"
        cur_jerry_test.execute(sql_device_ids)
        device_ids_lst = [i[0] for i in cur_jerry_test.fetchall()]
        db_jerry_test.close()

        # 获取搜索词及其近义词对应的tag
        all_word_tags = get_all_word_tags()
        all_tag_tag_type = get_all_tag_tag_type()

        # 3级tag对应的2级tag
        all_3tag_2tag = get_all_3tag_2tag()

        # 画像冷启动
        hot_search_words = get_hot_search_words_tag()
        hot_search_words_portrait = list()
        for tag_info in hot_search_words:
            tmp = dict()
            tmp["tag_score"] = 10
            tmp["weight"] = 10
            tmp["tag2"] = tag_info["id"]
            hot_search_words_portrait.append(tmp)
        gm_kv_cli = redis.Redis(host="172.16.40.135", port=5379, db=2, socket_timeout=2000)
        hot_search_words_portrait_portrait_key = "user:service_coldstart_tags"
        hot_search_words_portrait_json = json.dumps(hot_search_words_portrait)
        gm_kv_cli.set(hot_search_words_portrait_portrait_key, hot_search_words_portrait_json)
        gm_kv_cli.expire(hot_search_words_portrait_portrait_key, time=30 * 24 * 60 * 60)

        # rdd
        sparkConf = SparkConf().set("spark.hive.mapred.supports.subdirectories", "true") \
            .set("spark.hadoop.mapreduce.input.fileinputformat.input.dir.recursive", "true") \
            .set("spark.tispark.plan.allow_index_double_read", "false") \
            .set("spark.tispark.plan.allow_index_read", "true") \
            .set("spark.sql.extensions", "org.apache.spark.sql.TiExtensions") \
            .set("spark.tispark.pd.addresses", "172.16.40.170:2379").set("spark.io.compression.codec", "lzf") \
            .set("spark.driver.maxResultSize", "8g").set("spark.sql.avro.compression.codec", "snappy")

        spark = SparkSession.builder.config(conf=sparkConf).enableHiveSupport().getOrCreate()
        spark.sparkContext.setLogLevel("WARN")
        spark.sparkContext.addPyFile("/srv/apps/ffm-baseline_git/eda/smart_rank/tool.py")
        device_ids_lst_rdd = spark.sparkContext.parallelize(device_ids_lst)
        result = device_ids_lst_rdd.repartition(100).map(lambda x: get_user_service_portrait(x, all_word_tags, all_tag_tag_type, all_3tag_2tag))
        result.collect()

    except Exception as e:
        send_email("dist_update_user_portrait_service", "dist_update_user_portrait_service", "dist_update_user_portrait_service")