package com.gmei

import java.io.Serializable

import org.apache.spark.sql.functions.udf
import com.gmei.WeafareStat.{defaultParams, parser}
import org.apache.spark.sql.{SaveMode, TiContext}
import org.apache.log4j.{Level, Logger}
import scopt.OptionParser
import com.gmei.lib.AbstractParams
import java.io._
import java.text.SimpleDateFormat
import java.util.Calendar

import org.apache.spark

object app_list {

  Logger.getLogger("org.apache.spark").setLevel(Level.WARN)
  Logger.getLogger("org.apache.eclipse.jetty.server").setLevel(Level.OFF)

  case class Params(env: String = "dev",
                    date: String = "2018-08-01"
                   ) extends AbstractParams[Params] with Serializable

  val defaultParams = Params()

  val parser = new OptionParser[Params]("Feed_EDA") {
    head("WeafareStat")
    opt[String]("env")
      .text(s"the databases environment you used")
      .action((x, c) => c.copy(env = x))
    opt[String] ("date")
      .text(s"the date you used")
      .action((x,c) => c.copy(date = x))
    note(
      """
        |For example, the following command runs this app on a tidb dataset:
        |
        | spark-submit --class com.gmei.WeafareStat ./target/scala-2.11/feededa-assembly-0.1.jar \
      """.stripMargin +
        s"|   --env ${defaultParams.env}"
    )
  }

  def main(args: Array[String]): Unit = {
    parser.parse(args, defaultParams).map { param =>
      GmeiConfig.setup(param.env)
      val spark_env = GmeiConfig.getSparkSession()
      val sc = spark_env._2

      val ti = new TiContext(sc)
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "diary_video")
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "data_feed_click")
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "blacklist")
      ti.tidbMapTable(dbName = "jerry_test", tableName = "bl_device_list")
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "data_feed_exposure")
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "merge_queue_table")


      import sc.implicits._
      val stat_date = GmeiConfig.getMinusNDate(1)
      println(param.date)
      val partition_date = param.date.replace("-","")
      println(partition_date)

      //自定义udf函数，增加dataframe 列
      val code = (arg: String) => {
        if (arg.getClass.getName == "java.lang.String") partition_date.toInt else 0.toInt
      }

      val addCol = udf(code)
      //以上为udf函数


      //获取策略命中用户device_id
      val app_list = sc.sql(
        s"""
           |select distinct(cl_id) as device_id, user_id as user_id, params['installed_app_info'] as app_list
           |from online.tl_hdfs_maidian_view
           |where action="user_installed_all_app_info"
           |and partition_date = '${partition_date}'
         """.stripMargin
      )
      //app_list.show()
      import sc.implicits._
      val rdd_df = app_list.rdd.map(x =>(x(0).toString,x(1).toString,x(2).toString))
        .filter(x => x._3.contains("新氧美容")).map(x => (x._1,x._2)).collect().toList.toDF("device_id","user_id")
      rdd_df.show()
      //rdd_df.withColumn("stat_date",addCol(rdd_df("device_id")))
      rdd_df.createOrReplaceTempView("device_id")

      val temp = sc.sql(
        s"""
           |select *
           |from device_id
           |where device_id not in (select device_id from bl_device_list)
           |and device_id not in (select device_id from blacklist)
         """.stripMargin
      )
      val tempp=temp.withColumn("stat_date",addCol(temp("device_id")))

      temp.show()

      GmeiConfig.writeToJDBCTable(tempp, "device_id_coincidence", SaveMode.Append)

    }


  }

}




//以下object进行数据统计分析
object coincidence_xinyang {

  Logger.getLogger("org.apache.spark").setLevel(Level.WARN)
  Logger.getLogger("org.apache.eclipse.jetty.server").setLevel(Level.OFF)

  case class Params(env: String = "dev",
                    date: String = "2018-08-01"
                   ) extends AbstractParams[Params] with Serializable

  val defaultParams = Params()

  val parser = new OptionParser[Params]("Feed_EDA") {
    head("WeafareStat")
    opt[String]("env")
      .text(s"the databases environment you used")
      .action((x, c) => c.copy(env = x))
    opt[String] ("date")
      .text(s"the date you used")
      .action((x,c) => c.copy(date = x))
    note(
      """
        |For example, the following command runs this app on a tidb dataset:
        |
        | spark-submit --class com.gmei.WeafareStat ./target/scala-2.11/feededa-assembly-0.1.jar \
      """.stripMargin +
        s"|   --env ${defaultParams.env}"
    )
  }

  def main(args: Array[String]): Unit = {
    parser.parse(args, defaultParams).map { param =>
      GmeiConfig.setup(param.env)
      val spark_env = GmeiConfig.getSparkSession()
      val sc = spark_env._2

      val ti = new TiContext(sc)
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "diary_video")
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "data_feed_click")
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "blacklist")
      ti.tidbMapTable(dbName = "jerry_test", tableName = "bl_device_list")
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "data_feed_exposure")
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "device_id_coincidence")


      //println(param.date)
      //val partition_date = param.date.replace("-","")
      //println(partition_date)

      //获取昨天的日期
      def getYesterDay():String={
        var  dateFormat:SimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd")
        var cal:Calendar=Calendar.getInstance()
        cal.add(Calendar.DATE,-1)
        var yesterday=dateFormat.format(cal.getTime())
        yesterday
      }
      val yesterday=getYesterDay()
      println(yesterday)
      //获取一周前的日期
      def getWeekDay():String={
        var  dateFormat:SimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd")
        var cal:Calendar=Calendar.getInstance()
        cal.add(Calendar.DATE,-7)
        var yesterday=dateFormat.format(cal.getTime())
        yesterday
      }
      val pre_weekday=getWeekDay()
      println(pre_weekday)
      //获取一个月前的日期
      def getMonthDay():String={
        var  dateFormat:SimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd")
        var cal:Calendar=Calendar.getInstance()
        cal.add(Calendar.DATE,-30)
        var yesterday=dateFormat.format(cal.getTime())
        yesterday
      }
      val pre_monthday = getMonthDay()
      println(pre_monthday)



      //获取每日活跃用户中与新氧重合用户占比
      //1.每日活跃中与新氧重合用户数
      val data = yesterday.replace("-","")
      val yesterday_coincidence = sc.sql(
        s"""
           |select '${data}' as stat_date,count(distinct(device_id)) as yesterday_coincidence_num
           |from device_id_coincidence
           |where stat_date = '${data}'
         """.stripMargin
      )
      //2.每日活跃总用户数(采用曝光计算)
      val yesterday_expoure_num = sc.sql(
        s"""
           |select '${data}' as stat_date,count(distinct(device_id)) as yesterday_expoure_num
           |from data_feed_exposure
           |where stat_date = '${yesterday}'
           |and device_type !='App Store'
         """.stripMargin
      )

      //获取每周活跃用户中与新氧重合用户占比
      //1.每周活跃中与新氧重合用户数
      val week_day = pre_weekday.replace("-","")
      val week_coincidence = sc.sql(
        s"""
           |select '${data}' as stat_date,count(distinct(device_id)) as week_coincidence_num
           |from device_id_coincidence
           |where stat_date > '${week_day}'
         """.stripMargin
      )
      //2.每周活跃总用户(采用曝光计算)
      val week_expoure_num = sc.sql(
        s"""
           |select '${data}' as stat_date,count(distinct(device_id)) as week_expoure_num
           |from data_feed_exposure
           |where stat_date > '${pre_weekday}'
           |and device_type !='App Store'
         """.stripMargin
      )

      //获取每月活跃用户中与新氧用户重合用户占比
      //1.0 每月活跃中与新氧用户重合用户数
      val month_day=pre_monthday.replace("-","")
      val month_coincidence = sc.sql(
        s"""
           |select '${data}' as stat_date,count(distinct(device_id)) as month_coincidence_num
           |from device_id_coincidence
           |where stat_date > '${month_day}'
         """.stripMargin
      )
      //2.0 每月活跃总用户（采用曝光计算）
      val month_expoure_num = sc.sql(
        s"""
           |select '${data}' as stat_date,count(distinct(device_id)) as month_expoure_num
           |from data_feed_exposure
           |where stat_date > '${pre_monthday}'
         """.stripMargin
      )

      val result = yesterday_coincidence.join(yesterday_expoure_num,"stat_date")
          .join(week_coincidence,"stat_date")
          .join(week_expoure_num,"stat_date")
          .join(month_coincidence,"stat_date")
          .join(month_expoure_num,"stat_date")

      GmeiConfig.writeToJDBCTable(result, "coincidence_xinyang", SaveMode.Append)

      //截止目前获得的与新氧重合的用户数计算美购情况
      //1.重合用户的美购数
      val meigou_coincidence_num = sc.sql(
        s"""
           |select count(service_id) as meigou_coincidence_num
           |from online.ml_meigou_order_detail
           |where partition_date = '20181118'
           |and  pay_time  is  not  null
           |and  pay_time  >=  '2017-11-18'
           |and device_id in (select distinct(device_id) from device_id_coincidence)
         """.stripMargin
      )
      meigou_coincidence_num.show()


      //2.重合用户进行美购的用户数
      val meigou_pay_device = sc.sql(
        s"""
           |select count(DISTINCT(device_id)) as meigou_pay_device
           |from online.ml_meigou_order_detail
           |where partition_date = '20181118'
           |and  pay_time  is  not  null
           |and  pay_time  >=  '2017-11-18'
           |and device_id in (select distinct(device_id) from device_id_coincidence)
         """.stripMargin
      )
      meigou_pay_device.show()
      //3.所有用户的美购数
      val meigou_pay_all = sc.sql(
        s"""
           |select count(device_id) as meigou_pay_device
           |from online.ml_meigou_order_detail
           |where partition_date = '20181118'
           |and  pay_time  is  not  null
           |and  pay_time  >=  '2017-11-18'
           |and device_id not in (select device_id from bl_device_list)
           |and device_id not in (select device_id from blacklist)
         """.stripMargin
      )
      meigou_pay_all.show()

      //4.所有进行美购的用户数
      val meigou_pay_device_all = sc.sql(
        s"""
           |select count(DISTINCT(device_id)) as meigou_pay_device
           |from online.ml_meigou_order_detail
           |where partition_date = '20181118'
           |and  pay_time  is  not  null
           |and  pay_time  >=  '2017-11-18'
           |and device_id not in (select device_id from bl_device_list)
           |and device_id not in (select device_id from blacklist)
         """.stripMargin
      )
      meigou_pay_device_all.show()

      //截止目前获得的与新氧重合的用户数咨询统计
      val zixun_num_all = sc.sql(
        s"""
           |select count(cl_id)  as zixun_num_all
           |from online.tl_hdfs_maidian_view
           |where partition_date > '20180501'
           |and action = 'welfare_detail_click_message'
           |and cl_id not in (select device_id from bl_device_list)
           |and cl_id not in (select device_id from blacklist)
         """.stripMargin
      )
      zixun_num_all.show()

      val zixun_device_all = sc.sql(
        s"""
           |select count(distinct(cl_id)) zixun_device_all
           |from online.tl_hdfs_maidian_view
           |where partition_date > '20180501'
           |and action = 'welfare_detail_click_message'
           |and cl_id not in (select device_id from bl_device_list)
           |and cl_id not in (select device_id from blacklist)
         """.stripMargin
      )
      zixun_device_all.show()

      val zixun_num_co = sc.sql(
        s"""
           |select count(cl_id)  as zixun_num_co
           |from online.tl_hdfs_maidian_view
           |where partition_date > '20180501'
           |and action = 'welfare_detail_click_message'
           |and cl_id in (select distinct(device_id) from device_id_coincidence)
         """.stripMargin
      )
      zixun_num_co.show()

      val zixun_num_co_dis = sc.sql(
        s"""
           |select count(distinct(cl_id))  as zixun_num_co_dis
           |from online.tl_hdfs_maidian_view
           |where partition_date > '20180501'
           |and action = 'welfare_detail_click_message'
           |and cl_id in (select distinct(device_id) from device_id_coincidence)
         """.stripMargin
      )
      zixun_num_co_dis.show()





    }


  }

}
