name := """Node2vec"""

lazy val commonSettings = Seq(
  version := "0.2",
  organization := "com.gmei",
  scalaVersion := "2.11.8",
  test in assembly := {}
)

autoScalaLibrary := false

val sparkVersion = "2.2.1"

libraryDependencies ++= Seq(
  "org.apache.spark" %% "spark-core" % sparkVersion,
  "org.apache.spark" %% "spark-sql" % sparkVersion,
  "org.apache.spark" %% "spark-hive" % sparkVersion,
  "org.apache.spark" %% "spark-streaming" % sparkVersion,
  "org.apache.spark" %% "spark-streaming-kafka-0-10" % sparkVersion,
  "org.apache.spark" %% "spark-mllib" % sparkVersion,

  "mysql" % "mysql-connector-java" % "5.1.38",
  "com.typesafe" % "config" % "1.3.2",

  "org.apache.logging.log4j" % "log4j-scala" % "11.0" pomOnly(),
  "org.scalatest" %% "scalatest" % "3.0.5" % "test",
  "com.github.nscala-time" %% "nscala-time" % "2.18.0",
  "com.github.scopt" %% "scopt" % "3.7.0",
  "com.google.guava" % "guava" % "19.0"
)

lazy val root = (project in file(".")).settings(commonSettings: _*)

assemblyMergeStrategy in assembly := {
  case PathList("META-INF", xs @ _*) => MergeStrategy.discard
  case x => MergeStrategy.first
}
