import xlearn as xl
from config import *


def train():
    print("Start training")
    ffm_model = xl.create_ffm()
    ffm_model.setTrain(DIRECTORY_PATH + "train_ffm_data.csv")
    ffm_model.setValidate(DIRECTORY_PATH + "validation_ffm_data.csv")
    # log保存路径，如果不加这个参数，日志默认保存在/temp路径下，不符合规范
    param = {'task': 'binary', 'lr': lr, 'lambda': l2_lambda, 'metric': 'auc',"log":DIRECTORY_PATH+"result"}

    ffm_model.fit(param, DIRECTORY_PATH + "train/model.out")

    print("predicting")
    ffm_model.setTest(DIRECTORY_PATH + "test_ffm_data.csv")
    ffm_model.setSigmoid()
    ffm_model.predict(DIRECTORY_PATH + "train/model.out",DIRECTORY_PATH + "test_set_predict_output.txt")


