package com.gmei

import java.io.Serializable

import org.apache.spark.sql.functions.udf
import com.gmei.WeafareStat.{defaultParams, parser}
import org.apache.spark.sql.{SaveMode}
import org.apache.log4j.{Level, Logger}
import scopt.OptionParser
import com.gmei.lib.AbstractParams
import java.io._
import java.text.SimpleDateFormat
import java.util.Calendar

import org.apache.spark

object app_list {

  Logger.getLogger("org.apache.spark").setLevel(Level.WARN)
  Logger.getLogger("org.apache.eclipse.jetty.server").setLevel(Level.OFF)

  case class Params(env: String = "dev",
                    date: String = "2018-08-01"
                   ) extends AbstractParams[Params] with Serializable

  val defaultParams = Params()

  val parser = new OptionParser[Params]("Feed_EDA") {
    head("WeafareStat")
    opt[String]("env")
      .text(s"the databases environment you used")
      .action((x, c) => c.copy(env = x))
    opt[String] ("date")
      .text(s"the date you used")
      .action((x,c) => c.copy(date = x))
    note(
      """
        |For example, the following command runs this app on a tidb dataset:
        |
        | spark-submit --class com.gmei.WeafareStat ./target/scala-2.11/feededa-assembly-0.1.jar \
      """.stripMargin +
        s"|   --env ${defaultParams.env}"
    )
  }

  def main(args: Array[String]): Unit = {
    parser.parse(args, defaultParams).map { param =>
      GmeiConfig.setup(param.env)
      val spark_env = GmeiConfig.getSparkSession()
      val sc = spark_env._2

      sc.sql("use jerry_prod")

//      val ti = new TiContext(sc)
//      ti.tidbMapTable(dbName = "jerry_prod", tableName = "diary_video")
//      ti.tidbMapTable(dbName = "jerry_prod", tableName = "data_feed_click")
//      ti.tidbMapTable(dbName = "jerry_prod", tableName = "blacklist")
//      ti.tidbMapTable(dbName = "jerry_test", tableName = "bl_device_list")
//      ti.tidbMapTable(dbName = "jerry_prod", tableName = "data_feed_exposure")
//      ti.tidbMapTable(dbName = "jerry_prod", tableName = "merge_queue_table")


      import sc.implicits._
      val stat_date = GmeiConfig.getMinusNDate(1)
      println(param.date)
      val partition_date = param.date.replace("-","")
      println(partition_date)

      //自定义udf函数，增加dataframe 列
      val code = (arg: String) => {
        if (arg.getClass.getName == "java.lang.String") partition_date.toInt else 0.toInt
      }

      val addCol = udf(code)
      //以上为udf函数


      //机构ID
      val agency_id = sc.sql(
        s"""
           |SELECT DISTINCT(cl_id) as device_id
           |FROM online.ml_hospital_spam_pv_day
           |WHERE partition_date >= '20180402'
           |AND partition_date <= '20181120'
           |AND pv_ratio >= 0.95
           |UNION ALL
           |SELECT DISTINCT(cl_id) as device_id
           |FROM online.ml_hospital_spam_pv_month
           |WHERE partition_date >= '20171101'
           |AND partition_date <= '20181120'
           |AND pv_ratio >= 0.95
         """.stripMargin
      )
      agency_id.show()
      agency_id.createOrReplaceTempView("agency_id")

      //获取与新氧用户重合的用户device_id
      val app_list = sc.sql(
        s"""
           |select distinct(cl_id) as device_id, user_id as user_id, params['installed_app_info'] as app_list,channel
           |from online.tl_hdfs_maidian_view ov left join agency_id
           |on ov.cl_id = agency_id.device_id
           |where ov.action="user_installed_all_app_info"
           |and ov.partition_date = '${partition_date}'
           |and agency_id.device_id is null
           |and  ov.cl_id not in (select distinct(device_id) from blacklist)
         """.stripMargin
      )
      //app_list.show()
      import sc.implicits._
      val rdd_df = app_list.rdd.map(x =>(x(0).toString,x(1).toString,x(2).toString,x(3).toString))
        .filter(x => x._3.contains("新氧美容")).map(x => (x._1,x._2,x._3,x._4)).collect().toList.toDF("device_id","user_id","app_list","channel")
      rdd_df.show()
      //rdd_df.withColumn("stat_date",addCol(rdd_df("device_id")))
      rdd_df.createOrReplaceTempView("device_id")

      val temp = sc.sql(
        s"""
           |select *
           |from device_id
         """.stripMargin
      )
      val tempp=temp.withColumn("stat_date",addCol(temp("device_id")))

      tempp.show()

      GmeiConfig.writeToJDBCTable(tempp, "device_id_coincidence", SaveMode.Append)


//所有获得应用列表的用户device_id
      val app_list_all = sc.sql(
        s"""
           |select distinct(cl_id) as device_id, user_id as user_id,params['installed_app_info'] as app_list,channel
           |from online.tl_hdfs_maidian_view ov left join agency_id
           |on ov.cl_id = agency_id.device_id
           |where action="user_installed_all_app_info"
           |and agency_id.device_id is null
           |and ov.partition_date = '${partition_date}'
           |and ov.cl_id not in (select distinct(device_id) from blacklist)
         """.stripMargin
      )
      val tempp_list=app_list_all.withColumn("stat_date",addCol(app_list_all("device_id")))

      GmeiConfig.writeToJDBCTable(tempp_list, "device_id_applist", SaveMode.Append)


      //在更美有消费的用户列表
      val device_id_meigou = sc.sql(
        s"""
           |select DISTINCT(od.device_id) as device_id
           |from online.ml_meigou_order_detail od left join agency_id
           |on od.device_id = agency_id.device_id
           |where od.partition_date = '20181118'
           |and  od.pay_time  is  not  null
           |and  od.pay_time  >=  '2017-11-18'
           |and agency_id.device_id is null
           |and od.device_id not in (select distinct(device_id) from blacklist)
         """.stripMargin
      )
      device_id_meigou.createOrReplaceTempView("device_id_meigou")

      val app_list_meigou = sc.sql(
        s"""
           |select distinct(ov.cl_id) as device_id, user_id as user_id,params['installed_app_info'] as app_list,channel
           |from online.tl_hdfs_maidian_view ov left join device_id_meigou
           |on ov.cl_id = device_id_meigou.device_id
           |where ov.action="user_installed_all_app_info"
           |and device_id_meigou.device_id is not null
           |and ov.partition_date = '${partition_date}'
         """.stripMargin
      )
      val applist_meigou=app_list_meigou.withColumn("stat_date",addCol(app_list_meigou("device_id")))
      GmeiConfig.writeToJDBCTable(applist_meigou, "device_id_applist_meigou", SaveMode.Append)



    }


  }

}




//以下object进行数据统计分析
object coincidence_xinyang {

  Logger.getLogger("org.apache.spark").setLevel(Level.WARN)
  Logger.getLogger("org.apache.eclipse.jetty.server").setLevel(Level.OFF)

  case class Params(env: String = "dev",
                    date: String = "2018-08-01"
                   ) extends AbstractParams[Params] with Serializable

  val defaultParams = Params()

  val parser = new OptionParser[Params]("Feed_EDA") {
    head("WeafareStat")
    opt[String]("env")
      .text(s"the databases environment you used")
      .action((x, c) => c.copy(env = x))
    opt[String] ("date")
      .text(s"the date you used")
      .action((x,c) => c.copy(date = x))
    note(
      """
        |For example, the following command runs this app on a tidb dataset:
        |
        | spark-submit --class com.gmei.WeafareStat ./target/scala-2.11/feededa-assembly-0.1.jar \
      """.stripMargin +
        s"|   --env ${defaultParams.env}"
    )
  }

  def main(args: Array[String]): Unit = {
    parser.parse(args, defaultParams).map { param =>
      GmeiConfig.setup(param.env)
      val spark_env = GmeiConfig.getSparkSession()
      val sc = spark_env._2

      sc.sql("use jerry_prod")

//      val ti = new TiContext(sc)
//      ti.tidbMapTable(dbName = "jerry_prod", tableName = "blacklist")
//      ti.tidbMapTable(dbName = "jerry_prod", tableName = "device_id_applist")
//      ti.tidbMapTable(dbName = "jerry_prod", tableName = "device_id_coincidence")


      //println(param.date)
      //val partition_date = param.date.replace("-","")
      //println(partition_date)

      //获取昨天的日期
      def getYesterDay():String={
        var  dateFormat:SimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd")
        var cal:Calendar=Calendar.getInstance()
        cal.add(Calendar.DATE,-1)
        var yesterday=dateFormat.format(cal.getTime())
        yesterday
      }
      val yesterday=getYesterDay()
      println(yesterday)
      //获取一周前的日期
      def getWeekDay():String={
        var  dateFormat:SimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd")
        var cal:Calendar=Calendar.getInstance()
        cal.add(Calendar.DATE,-7)
        var yesterday=dateFormat.format(cal.getTime())
        yesterday
      }
      val pre_weekday=getWeekDay()
      println(pre_weekday)
      //获取一个月前的日期
      def getMonthDay():String={
        var  dateFormat:SimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd")
        var cal:Calendar=Calendar.getInstance()
        cal.add(Calendar.DATE,-30)
        var yesterday=dateFormat.format(cal.getTime())
        yesterday
      }
      val pre_monthday = getMonthDay()
      println(pre_monthday)


      //获取每日活跃用户中与新氧重合用户占比
      //1.每日活跃中与新氧重合用户数
      val yesterday_data = yesterday.replace("-","")
      val yesterday_coincidence = sc.sql(
        s"""
           |select '${yesterday_data}' as stat_date,count(distinct(device_id)) as yesterday_coincidence_num
           |from device_id_coincidence
           |where stat_date = '${yesterday_data}'
         """.stripMargin
      )
      //2.获得应用列表的每日活跃总用户数
      val yesterday_expoure_num = sc.sql(
        s"""
           |select '${yesterday_data}' as stat_date,count(distinct(device_id)) as yesterday_expoure_num
           |from device_id_applist
           |where stat_date = '${yesterday_data}'
         """.stripMargin
      )


      //获取每周活跃用户中与新氧重合用户占比
      //1.每周活跃中与新氧重合用户数
      val week_day = pre_weekday.replace("-","")
      val week_coincidence = sc.sql(
        s"""
           |select '${yesterday_data}' as stat_date,count(distinct(device_id)) as week_coincidence_num
           |from device_id_coincidence
           |where stat_date >= '${week_day}'
         """.stripMargin
      )
      //2.获得应用列表的每周活跃总用户
      val week_expoure_num = sc.sql(
        s"""
           |select '${yesterday_data}' as stat_date,count(distinct(device_id)) as week_expoure_num
           |from device_id_applist
           |where stat_date >= '${week_day}'
         """.stripMargin
      )

 /*     //获取每月活跃用户中与新氧用户重合用户占比
      //1.0 每月活跃中与新氧用户重合用户数
      val month_day=pre_monthday.replace("-","")
      val month_coincidence = sc.sql(
        s"""
           |select '${data}' as stat_date,count(distinct(device_id)) as month_coincidence_num
           |from device_id_coincidence
           |where stat_date > '${month_day}'
         """.stripMargin
      )
      //2.0 获得应用列表的每月活跃总用户
      val month_expoure_num = sc.sql(
        s"""
           |select '${data}' as stat_date,count(distinct(cl_id)) as month_expoure_num
           |from online.tl_hdfs_maidian_view
           |where partition_date >= '${month_day}'
           |and action="user_installed_all_app_info"
           |and cl_id not in (select device_id from bl_device_list)
           |and cl_id not in (select device_id from blacklist)
         """.stripMargin
      )
*/
      val result = yesterday_coincidence.join(yesterday_expoure_num,"stat_date")
          .join(week_coincidence,"stat_date")
          .join(week_expoure_num,"stat_date")

      GmeiConfig.writeToJDBCTable(result, "coincidence_xinyang", SaveMode.Append)

      //获取到的应用列表用户中截止目前获得的与新氧重合的用户数计算美购情况
      //* 重合用户的id
      val coincidence_id = sc.sql(
        s"""
           |select distinct(device_id) as device_id
           |from device_id_coincidence
         """.stripMargin
      )
      coincidence_id.createOrReplaceTempView("coincidence_id")


//获取应用列表的所有用户id
      val all_id = sc.sql(
        s"""
           |select distinct(device_id) as device_id
           |from device_id_applist
         """.stripMargin
      )
      all_id.createOrReplaceTempView("all_id")

      //* 所有获得用户列表的用户id
      //1.重合用户的美购数
      val meigou_1 = sc.sql(
        s"""
           |select count(ov.device_id) as meigou_1
           |from online.ml_meigou_order_detail ov left join coincidence_id
           |on ov.device_id = coincidence_id.device_id
           |where ov.partition_date = '20181120'
           |and coincidence_id.device_id is not null
           |and  ov.pay_time  is  not  null
           |and  ov.pay_time  >=  '2017-11-18'
         """.stripMargin
      )
      meigou_1.show()


      //2.重合用户进行美购的用户数
      val meigou_2 = sc.sql(
        s"""
           |select count(distinct(ov.device_id)) as meigou_2
           |from online.ml_meigou_order_detail ov left join coincidence_id
           |on ov.device_id = coincidence_id.device_id
           |where ov.partition_date = '20181120'
           |and coincidence_id.device_id is not null
           |and  ov.pay_time  is  not  null
           |and  ov.pay_time  >=  '2017-11-18'
         """.stripMargin
      )
      meigou_2.show()
      //3.所有获得应用列表的用户的美购数
      val meigou_3 = sc.sql(
        s"""
           |select count(od.device_id) as meigou_3
           |from online.ml_meigou_order_detail od  inner join all_id
           |on od.device_id = all_id.device_id
           |where od.partition_date = '20181120'
           |and  all_id.device_id is not null
           |and  od.pay_time  is  not  null
           |and  od.pay_time  >=  '2017-11-18'
         """.stripMargin
      )
      meigou_3.show()

      //4.所有获得应用列表用户进行美购的用户数
      val meigou_4 = sc.sql(
        s"""
           |select count(distinct(od.device_id)) as meigou_4
           |from online.ml_meigou_order_detail od  inner join all_id
           |on od.device_id = all_id.device_id
           |where partition_date = '20181120'
           |and  all_id.device_id is not null
           |and  od.pay_time  is  not  null
           |and  od.pay_time  >=  '2017-11-18'
         """.stripMargin
      )
      meigou_4.show()
      // 5.所有用户过去一年的美购数
      val meigou_5 = sc.sql(
        s"""
           |select count(device_id) as meigou_5
           |from online.ml_meigou_order_detail
           |where partition_date = '20181120'
           |and  pay_time  is  not  null
           |and  pay_time  >=  '2017-11-18'
         """.stripMargin
      )
      meigou_5.show()

      // 56.所有用户过去一年的美购用户数
      val meigou_6 = sc.sql(
        s"""
           |select count(distinct(device_id)) as meigou_6
           |from online.ml_meigou_order_detail
           |where partition_date = '20181120'
           |and  pay_time  is  not  null
           |and  pay_time  >=  '2017-11-18'
         """.stripMargin
      )
      meigou_6.show()


      //截止目前获得的与新氧重合的用户数咨询统计
      //1.与新氧重合用户的美购咨询数
      val zixun_1 = sc.sql(
        s"""
           |select count(ov.cl_id)  as zixun_1
           |from online.tl_hdfs_maidian_view ov left join coincidence_id
           |on ov.cl_id = coincidence_id.device_id
           |where partition_date >= '20180501'
           |and coincidence_id.device_id is not null
           |and action = 'welfare_detail_click_message'
         """.stripMargin
      )
      zixun_1.show()
      //2.与新氧重合用户的美购咨询用户数
      val zixun_2 = sc.sql(
        s"""
           |select count(distinct(ov.cl_id))  as zixun_2
           |from online.tl_hdfs_maidian_view ov left join coincidence_id
           |on ov.cl_id = coincidence_id.device_id
           |where partition_date >= '20180501'
           |and coincidence_id.device_id is not null
           |and action = 'welfare_detail_click_message'
         """.stripMargin
      )
      zixun_2.show()
      //3.已经获得应用列表用户的美购咨询次数
      val zixun_3 = sc.sql(
        s"""
           |select count(ov.cl_id)  as zixun_3
           |from online.tl_hdfs_maidian_view ov left join all_id
           |on ov.cl_id = all_id.device_id
           |where partition_date >= '20180501'
           |and all_id.device_id is not null
           |and ov.action = 'welfare_detail_click_message'
         """.stripMargin
      )
      zixun_3.show()
      //4.已经获得应用列表用户的美购咨询用户数
      val zixun_4 = sc.sql(
        s"""
           |select count(distinct(ov.cl_id))  as zixun_4
           |from online.tl_hdfs_maidian_view ov left join all_id
           |on ov.cl_id = all_id.device_id
           |where partition_date >= '20180501'
           |and all_id.device_id is not null
           |and ov.action = 'welfare_detail_click_message'
         """.stripMargin
      )
      zixun_4.show()
      //5.所有用户的美购咨询数
      val zixun_5 = sc.sql(
        s"""
           |select count(cl_id)  as zixun_5
           |from online.tl_hdfs_maidian_view
           |where partition_date >= '20180501'
           |and action = 'welfare_detail_click_message'
         """.stripMargin
      )
      zixun_5.show()

      //6.所有用户的美购咨询用户数
      val zixun_6 = sc.sql(
        s"""
           |select count(distinct(cl_id))  as zixun_6
           |from online.tl_hdfs_maidian_view
           |where partition_date >= '20180501'
           |and action = 'welfare_detail_click_message'
         """.stripMargin
      )
      zixun_6.show()





    }


  }

}
