import xlearn as xl
from config import *


def train():
    print("Start training")
    ffm_model = xl.create_ffm()
    ffm_model.setTrain(DIRECTORY_PATH + "train{0}-{1}.csv".format(DATA_START_DATE, VALIDATION_DATE))
    ffm_model.setValidate(DIRECTORY_PATH + "validation{0}.csv".format(VALIDATION_DATE))

    param = {'task': 'binary', 'lr': lr, 'lambda': l2_lambda, 'metric': 'auc'}

    ffm_model.fit(param, DIRECTORY_PATH + "model_{0}-{1}_lr{2}_lambda{3}.out".format(DATA_START_DATE,
                                                                                     DATA_END_DATE, lr, l2_lambda))

    print("predicting")
    ffm_model.setTest(DIRECTORY_PATH + "test{0}.csv".format(TEST_DATE))
    ffm_model.setSigmoid()
    ffm_model.predict(DIRECTORY_PATH + "model_{0}-{1}_lr{2}_lambda{3}.out".format(DATA_START_DATE,
                                                                                  DATA_END_DATE, lr, l2_lambda),
                      DIRECTORY_PATH + "testset{0}_output_model_{1}-{2}_lr{3}_lambda{4}.txt".format(TEST_DATE,
                                                                                                    DATA_START_DATE,
                                                                                                    DATA_END_DATE, lr,
                                                                                                    l2_lambda))


