import redis
import datetime
import json


def filter_history(device_id,cid_list):
    r = redis.StrictRedis.from_url("redis://redis.paas-test.env:6379/1")
    all_key = "TS:recommend_tractate_set:device_id:" + str(device_id)
    old_key = "TS:recommend_tractate_set:device_id:'{}':'{}'"\
        .format(device_id,(datetime.date.today() - datetime.timedelta(days=14)).strftime("%Y-%m-%d"))
    today_key = "TS:recommend_tractate_set:device_id:'{}':'{}'"\
        .format(device_id,datetime.date.today().strftime("%Y-%m-%d"))
    if r.exists(today_key):
        r.sadd(today_key, *cid_list)
    else:
        r.sadd(today_key, *cid_list)
        r.expire(today_key,15*24*60*60)
    if r.exists(all_key) and r.exists(old_key):
        r.sdiffstore(all_key, all_key, old_key)
        r.delete(old_key)
        r.expire(all_key, time=13*24*60*60)

    r.sadd(all_key, *r.smembers(today_key))


def get_dairy():
    device_id = "868080041007173"
    r = redis.StrictRedis.from_url("redis://redis.paas-test.env:6379/0")

    dislike_key = str(device_id) + "_dislike_diary"
    dislike_cids = [2,20,40,61,81,101,121]
    r.sadd(dislike_key,*dislike_cids)
    print("不喜欢")
    print(r.smembers(dislike_key))

    user_portrait_diary_key = 'user_portrait_recommend_diary_queue:device_id:%s:%s' % \
                              (device_id, datetime.datetime.now().strftime('%Y-%m-%d'))
    user_cids = list(range(2,6))
    user_cids = [str(i) for i in user_cids]
    r.hset(user_portrait_diary_key,'diary_queue',json.dumps(user_cids))
    r.hset(user_portrait_diary_key, 'cursor', "0")
    r.hset(user_portrait_diary_key, 'len_cursor', "0")
    print("画像")
    print(r.hgetall(user_portrait_diary_key))

    search_diary_recommend_key = "TS:search_recommend_diary_queue:device_id:" + str(device_id)
    serach_cids = list(range(20,26))
    serach_cids = [str(i) for i in serach_cids]
    r.hset(search_diary_recommend_key, 'diary_queue', json.dumps(serach_cids))
    print("search")
    print(r.hgetall(search_diary_recommend_key))


    diary_recommend_key = "TS:recommend_diary_queue:device_id:" + str(device_id)
    ts_cids = list(range(40,46))
    ts_cids = [str(i) for i in ts_cids]
    r.hset(diary_recommend_key, 'diary_queue', json.dumps(ts_cids))
    print("ts")
    print(r.hgetall(diary_recommend_key))

    use_city_id = "beijing"
    personal_key = "device_diary_queue:device_id:" + device_id + ":city_id:" + use_city_id
    native_quue = ",".join([str(i) for i in range(60,80)])
    nearby_quue = ",".join([str(i) for i in range(80,100)])
    mea_queue = ",".join([str(i) for i in range(100,120)])
    nation_queue = ",".join([str(i) for i in range(120,130)])
    r.hset(personal_key,"native_queue",native_quue)
    r.hset(personal_key, "nearby_queue", nearby_quue)
    r.hset(personal_key, "nation_queue", nation_queue)
    r.hset(personal_key, "megacity_queue", mea_queue)
    print("personnal ")
    print(r.hgetall(personal_key))


def get_qa():
    device_id = "868080041007173"
    r = redis.StrictRedis.from_url("redis://redis.paas-test.env:6379/0")

    dislike_key = str(device_id) + "_dislike_qa"
    dislike_cids = [529401,529412,529403]
    r.sadd(dislike_key, *dislike_cids)
    print("不喜欢")
    print(r.smembers(dislike_key))

    search_qa_recommend_key = "TS:search_recommend_answer_queue:device_id:" + str(device_id)
    r.hset(search_qa_recommend_key,'answer_queue',json.dumps(list(range(529401,529408))))

    print(r.hgetall(search_qa_recommend_key))

def get_topic():
    device_id = "868080041007173"
    r = redis.StrictRedis.from_url("redis://redis.paas-test.env:6379/0")

    dislike_key = str(device_id) + "_dislike_tractate"
    dislike_cids = [2,37]
    r.sadd(dislike_key, *dislike_cids)
    print("不喜欢")
    print(r.smembers(dislike_key))

    search_topic_recommend_key = "TS:search_recommend_tractate_queue:device_id:" + str(device_id)
    r.hset(search_topic_recommend_key,'tractate_queue',json.dumps(list(range(1,4))))

    print(r.hgetall(search_topic_recommend_key))

def yanzheng():
    device_id = "E417C286-40A4-42F6-BDA9-AEEBD8FEC3B6"
    r = redis.Redis(host="172.16.40.135", port=5379, db=2, socket_timeout=2000)












if __name__ == "__main__":
    # cid = [16,18,20]
    # filter_history("hello",cid)
    get_topic()








