from __future__ import absolute_import
from __future__ import division
from __future__ import print_function
import pymysql
import smtplib
from email.mime.text import MIMEText
from email.utils import formataddr
from email.mime.multipart import MIMEMultipart
from email.mime.application import MIMEApplication
import redis
import datetime
from pyspark import SparkConf
import time
from pyspark.sql import SparkSession
import json
import numpy as np
import pandas as pd
from pyspark.sql.functions import lit
from pyspark.sql.functions import concat_ws


def get_user_device_id(user_id):
    try:
        db_zhengxing = pymysql.connect(host="172.16.30.141", port=3306, user="work",
                                       password="BJQaT9VzDcuPBqkd",
                                       db="zhengxing", cursorclass=pymysql.cursors.DictCursor)
        cur_zhengxing = db_zhengxing.cursor()

        sql = "select device_id from statistic_device where id = (select max(device_id) from statistic_device_user where user_id = %d) " % (int(user_id))
        cur_zhengxing.execute(sql)
        cl_id = cur_zhengxing.fetchall()
        if cl_id:
            return cl_id[0]["device_id"]
        else:
            return ""
    except Exception as e:
        print(e)


def get_user_history_order_service_tag(user_id, stat_date):
    try:
        if user_id:
            db_zhengxing = pymysql.connect(host="172.16.30.141", port=3306, user="work",
                                           password="BJQaT9VzDcuPBqkd",
                                           db="zhengxing", cursorclass=pymysql.cursors.DictCursor)
            cur_zhengxing = db_zhengxing.cursor()

            sql = "select a.tag_id from api_servicetag a left join api_tag b on a.tag_id=b.id " \
                  "where a.service_id in (select service_id from api_order where user_id={user_id} and status=1) " \
                  "and b.tag_type<'4' ".format(user_id=user_id)
            cur_zhengxing.execute(sql)
            tags_dict = cur_zhengxing.fetchall()

            tags_list = [i["tag_id"] for i in tags_dict]
            cl_id = get_user_device_id(user_id)
            db_jerry_test = pymysql.connect(host='172.16.40.158', port=4000, user='root', passwd='3SYz54LS9#^9sBvC',
                                            db='jerry_test', charset='utf8')
            cur_jerry_test = db_jerry_test.cursor()
            replace_sql = """replace into user_history_order_tags (stat_date, cl_id, user_id, tag_list) values("{stat_date}","{cl_id}",{user_id},"{tag_list}")"""\
                .format(stat_date=stat_date, cl_id=cl_id, user_id=user_id, tag_list=tags_list)
            cur_jerry_test.execute(replace_sql)
            db_jerry_test.commit()
            db_jerry_test.close()
            return 'sucess'
    except Exception as e:
        return 'pass'


if __name__ == '__main__':
    try:
        db_zhengxing = pymysql.connect(host="172.16.30.141", port=3306, user="work",
                                       password="BJQaT9VzDcuPBqkd",
                                       db="zhengxing", cursorclass=pymysql.cursors.DictCursor)
        cur_zhengxing = db_zhengxing.cursor()

        # 获取所有用户的设备id
        sql_device_ids = "select distinct user_id from api_order where status=1 and pay_time>'2017-08-16'"
        cur_zhengxing.execute(sql_device_ids)
        device_ids_lst = [i["user_id"] for i in cur_zhengxing.fetchall()]
        stat_date = datetime.datetime.today().strftime('%Y-%m-%d')

        # rdd
        sparkConf = SparkConf().set("spark.hive.mapred.supports.subdirectories", "true") \
            .set("spark.hadoop.mapreduce.input.fileinputformat.input.dir.recursive", "true") \
            .set("spark.tispark.plan.allow_index_double_read", "false") \
            .set("spark.tispark.plan.allow_index_read", "true") \
            .set("spark.sql.extensions", "org.apache.spark.sql.TiExtensions") \
            .set("spark.tispark.pd.addresses", "172.16.40.158:2379").set("spark.io.compression.codec", "lzf") \
            .set("spark.driver.maxResultSize", "8g").set("spark.sql.avro.compression.codec", "snappy")

        spark = SparkSession.builder.config(conf=sparkConf).enableHiveSupport().getOrCreate()
        spark.sparkContext.setLogLevel("WARN")

        device_ids_lst_rdd = spark.sparkContext.parallelize(device_ids_lst)
        gm_kv_cli = redis.Redis(host="172.16.40.135", port=5379, db=6, socket_timeout=2000)
        result = device_ids_lst_rdd.repartition(100).map(lambda x: get_user_history_order_service_tag(x, stat_date))
        result.collect()

    except Exception as e:
        print(e)