package com.gmei

import java.io.Serializable

import com.gmei.WeafareStat.{defaultParams, parser}
import org.apache.spark.sql.{SaveMode, TiContext}
import org.apache.log4j.{Level, Logger}
import scopt.OptionParser
import com.gmei.lib.AbstractParams

object temp_count {

  Logger.getLogger("org.apache.spark").setLevel(Level.WARN)
  Logger.getLogger("org.apache.eclipse.jetty.server").setLevel(Level.OFF)

  case class Params(env: String = "dev",
                    date: String = "2018-08-01"
                   ) extends AbstractParams[Params] with Serializable

  val defaultParams = Params()

  val parser = new OptionParser[Params]("Feed_EDA") {
    head("WeafareStat")
    opt[String]("env")
      .text(s"the databases environment you used")
      .action((x, c) => c.copy(env = x))
    opt[String] ("date")
      .text(s"the date you used")
      .action((x,c) => c.copy(date = x))
    note(
      """
        |For example, the following command runs this app on a tidb dataset:
        |
        | spark-submit --class com.gmei.WeafareStat ./target/scala-2.11/feededa-assembly-0.1.jar \
      """.stripMargin +
        s"|   --env ${defaultParams.env}"
    )
  }

  def main(args: Array[String]): Unit = {
    parser.parse(args, defaultParams).map { param =>
      GmeiConfig.setup(param.env)
      val spark_env = GmeiConfig.getSparkSession()
      val sc = spark_env._2

      val ti = new TiContext(sc)
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "diary_video")
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "data_feed_click")
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "blacklist")
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "data_feed_exposure")
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "merge_queue_table")


//      val stat_date = GmeiConfig.getMinusNDate(1)
      val stat_date = param.date
      //println(param.date)
      val partition_date = stat_date.replace("-","")
      val decive_id_oldUser = sc.sql(
        s"""
           |select distinct(device_id) as device_id
           |from online.ml_device_day_active_status
           |where active_type = '4'
           |and first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
           |    ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
           |    ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
           |    ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
           |    ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
           |    ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
           |    ,'promotion_shike','promotion_julang_jl03','','unknown')
           |and partition_date ='${partition_date}'
         """.stripMargin
      )
      decive_id_oldUser.createOrReplaceTempView("device_id_old")


      val clk_count_oldUser = sc.sql(
        s"""
           |select '${stat_date}' as stat_date, count(jd.cid_id) as clk_count_oldUser
           |from data_feed_click jd inner join device_id_old
           |on jd.device_id = device_id_old.device_id
           |where  (jd.cid_type = 'diary' or jd.cid_type = 'diary_video')
           |and jd.device_id not in (select device_id from blacklist)
           |and jd.city_id in ("huzhou","liuan","zhenjiang","taizhou","jiaxing","weihai","maanshan","changzhou","shantou","nantong","yantai","wuxi","huhehaote","taiyuan","xining","yinchuan")
           |and jd.stat_date ='${stat_date}'
         """.stripMargin
      )

      val imp_count_oldUser = sc.sql(
        s"""
           |select '${stat_date}' as stat_date, count(cid_id) as imp_count_oldUser
           |from data_feed_exposure je inner join device_id_old
           |on je.device_id = device_id_old.device_id
           |where je.cid_type = 'diary'
           |and je.device_id not in (select device_id from blacklist)
           |and je.city_id in ("huzhou","liuan","zhenjiang","taizhou","jiaxing","weihai","maanshan","changzhou","shantou","nantong","yantai","wuxi","huhehaote","taiyuan","xining","yinchuan")
           |and je.stat_date ='${stat_date}'
         """.stripMargin
      )

      val clk_count_all = sc.sql(
        s"""
           |select '${stat_date}' as stat_date, count(cid_id) as clk_count_all
           |from data_feed_click
           |where  (cid_type = 'diary' or cid_type = 'diary_video')
           |and device_id not in (select device_id from blacklist)
           |and city_id in ("huzhou","liuan","zhenjiang","taizhou","jiaxing","weihai","maanshan","changzhou","shantou","nantong","yantai","wuxi","huhehaote","taiyuan","xining","yinchuan")
           |and stat_date ='${stat_date}'
         """.stripMargin
      )

      val imp_count__all = sc.sql(
        s"""
           |select '${stat_date}' as stat_date, count(cid_id) as imp_count_all
           |from data_feed_exposure
           |where cid_type = 'diary'
           |and device_id not in (select device_id from blacklist)
           |and city_id in ("huzhou","liuan","zhenjiang","taizhou","jiaxing","weihai","maanshan","changzhou","shantou","nantong","yantai","wuxi","huhehaote","taiyuan","xining","yinchuan")
           |and stat_date ='${stat_date}'
         """.stripMargin
      )

      val clk_count_oldUser_Contrast = sc.sql(
        s"""
           |select '${stat_date}' as stat_date, count(cid_id) as clk_count_oldUser_Contrast
           |from data_feed_click jd inner join device_id_old
           |on jd.device_id = device_id_old.device_id
           |where  (jd.cid_type = 'diary' or jd.cid_type = 'diary_video')
           |and jd.device_id regexp'1$$'
           |and jd.device_id not in (select device_id from blacklist)
           |and jd.city_id in ("huzhou","liuan","zhenjiang","taizhou","jiaxing","weihai","maanshan","changzhou","shantou","nantong","yantai","wuxi","huhehaote","taiyuan","xining","yinchuan")
           |and jd.stat_date ='${stat_date}'
         """.stripMargin
      )

      val imp_count_oldUser_Contrast = sc.sql(
        s"""
           |select '${stat_date}' as stat_date, count(cid_id) as imp_count_oldUser_Contrast
           |from data_feed_exposure je inner join device_id_old
           |on je.device_id = device_id_old.device_id
           |where je.cid_type = 'diary'
           |and je.device_id regexp'1$$'
           |and je.device_id not in (select device_id from blacklist)
           |and je.city_id in ("huzhou","liuan","zhenjiang","taizhou","jiaxing","weihai","maanshan","changzhou","shantou","nantong","yantai","wuxi","huhehaote","taiyuan","xining","yinchuan")
           |and je.stat_date ='${stat_date}'
         """.stripMargin
      )




      val result1 = clk_count_oldUser.join(imp_count_oldUser,"stat_date")
        .join(clk_count_all,"stat_date")
        .join(imp_count__all,"stat_date")
        .join(clk_count_oldUser_Contrast,"stat_date")
        .join(imp_count_oldUser_Contrast,"stat_date")
      result1.show()

      GmeiConfig.writeToJDBCTable(result1, "ffm_diary_ctr", SaveMode.Append)


    }


  }

}




object Repeated_content_recommendation {

  Logger.getLogger("org.apache.spark").setLevel(Level.WARN)
  Logger.getLogger("org.apache.eclipse.jetty.server").setLevel(Level.OFF)

  case class Params(env: String = "dev",
                    date: String = "2018-08-01"
                   ) extends AbstractParams[Params] with Serializable

  val defaultParams = Params()

  val parser = new OptionParser[Params]("Feed_EDA") {
    head("WeafareStat")
    opt[String]("env")
      .text(s"the databases environment you used")
      .action((x, c) => c.copy(env = x))
    opt[String] ("date")
      .text(s"the date you used")
      .action((x,c) => c.copy(date = x))
    note(
      """
        |For example, the following command runs this app on a tidb dataset:
        |
        | spark-submit --class com.gmei.WeafareStat ./target/scala-2.11/feededa-assembly-0.1.jar \
      """.stripMargin +
        s"|   --env ${defaultParams.env}"
    )
  }

  def main(args: Array[String]): Unit = {
    parser.parse(args, defaultParams).map { param =>
      GmeiConfig.setup(param.env)
      val spark_env = GmeiConfig.getSparkSession()
      val sc = spark_env._2

      val ti = new TiContext(sc)
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "data_feed_exposure_precise")
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "data_feed_click")
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "blacklist")
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "data_feed_exposure")
      ti.tidbMapTable(dbName = "jerry_prod", tableName = "merge_queue_table")


      //      val stat_date = GmeiConfig.getMinusNDate(1)
      val stat_date = param.date
      val partition_date = stat_date.replace("-","")


      val exp_diary = sc.sql(
        s"""
           |select concat_ws('|',device_id,cid_id)
           |from data_feed_exposure
           |where cid_type = 'diary'
           |and device_id not in (select device_id from blacklist)
           |and stat_date ='${stat_date}'
         """.stripMargin
      )
      exp_diary.show()
      val get_result =exp_diary.rdd.map((_, 1)).reduceByKey(_ + _)
              .sortBy(_._2,false)

      val more_than2=get_result.filter(_._2 >=2).map(_._2).reduce((x,y)=>x+y)
      println(more_than2)
      val all =get_result.map(_._2).reduce((x,y)=>x+y)
      println(all)
      val repeated_rate= more_than2 / all.toDouble
      println(repeated_rate)
      val test=List((stat_date,repeated_rate))
      val df = sc.createDataFrame(test)

      GmeiConfig.writeToJDBCTable(df, table = "Repeated_evaluation_indicator", SaveMode.Append)


//      val temp=get_result.collect()
//            for (i <- 0 until 30 ) {
//              println(temp(i))
//            }
    }


  }

}