package com.gmei

import java.io.Serializable

import com.gmei.WeafareStat.{defaultParams, parser}
import org.apache.spark.sql.{SaveMode}
import org.apache.log4j.{Level, Logger}
import scopt.OptionParser
import com.gmei.lib.AbstractParams
import org.dmg.pmml.True

import scala.util.Try
import scala.util.parsing.json.JSON

object Search_keywords_count {

  Logger.getLogger("org.apache.spark").setLevel(Level.WARN)
  Logger.getLogger("org.apache.eclipse.jetty.server").setLevel(Level.OFF)

  case class Params(env: String = "dev",
                    date: String = "2018-08-01"
                   ) extends AbstractParams[Params] with Serializable

  val defaultParams = Params()

  val parser = new OptionParser[Params]("Feed_EDA") {
    head("Search_keywords_count")
    opt[String]("env")
      .text(s"the databases environment you used")
      .action((x, c) => c.copy(env = x))
    opt[String] ("date")
      .text(s"the date you used")
      .action((x,c) => c.copy(date = x))
    note(
      """
        |For example, the following command runs this app on a tidb dataset:
        |
        | spark-submit --class com.gmei.WeafareStat ./target/scala-2.11/feededa-assembly-0.1.jar \
      """.stripMargin +
        s"|   --env ${defaultParams.env}"
    )
  }

  //定义异常捕获
  def catch_error(x:String)={
    val in =JSON.parseFull(x)
    try{
      in.toString
    }
    catch {
      case e: ArithmeticException => {e.printStackTrace();e.toString}
    }
  }


  def main(args: Array[String]): Unit = {
    parser.parse(args, defaultParams).map { param =>
      GmeiConfig.setup(param.env)
      val spark_env = GmeiConfig.getSparkSession()
      val sc = spark_env._2
      val stat_date = GmeiConfig.getMinusNDate(1)   //获取昨日日期
      //println(param.date)
      val partition_date = stat_date.replace("-","")

      sc.udf.register("test_udf",test.test_udf _)


      //搜索关键词提取
      val search_keywords = sc.sql(
        s"""
           |select params['query'] as search_keywords
           |from online.tl_hdfs_maidian_view
           |where (action = 'do_search' or action = 'search_result_click_search' or action ='on_click_jumping_hot_word')
           |and partition_date ='20190108'
         """.stripMargin
      ).show(20)/*.rdd.map(x=>{
        val b=JSON.parseFull(x.toString())
        b match {
          // Matches if jsonStr is valid JSON and represents a Map of Strings to Any
          case Some(map: Map[String, Any]) => println(map)
          case None => println("Parsing failed")
          case other => println("Unknown data structure: " + other)
        }
      }).foreach(println)*/
//      search_keywords.show()

//      val tempp=search_keywords.collect()
//      for (i <- 0 until tempp.length ) {
//        println(tempp(i))
//              }
//      GmeiConfig.writeToJDBCTable(search_keywords, table = "temp_search_keywords", SaveMode.Overwrite)
      //搜索次数统计
//      val search_count = sc.sql(
//        s"""
//           |select '${stat_date}' as stat_date,count(params['query']) as search_num
//           |from online.tl_hdfs_maidian_view
//           |where (action = 'do_search' or action = 'search_result_click_search')
//           |and partition_date ='20190107'
//         """.stripMargin
//      )
//      search_count.show()

//      val get_result =search_keywords.rdd.map((_, 1)).reduceByKey(_ + _)
//        .sortBy(_._2,false)
//      val temp=get_result.collect()
//      for (i <- 0 until temp.length ) {
//        println(temp(i))
//      }

    }

  }

}

object test {
  def test_udf(param:Map[String,String]):String = {
    try {
      JSON.parseFull(param.toString())
      "a"
    } catch{
      case e:Exception => ""
    }

//    if Try(JSON.parseFull(param.toString())) {
//
//
//    }


  }
}