import pymysql
import pandas as pd
import time


def get_data_by_mysql(host, port, user, passwd, db, sql):
    try:
        db = pymysql.connect(host=host, port=port, user=user, passwd=passwd, db=db, cursorclass=pymysql.cursors.DictCursor)
        cursor = db.cursor()
        cursor.execute(sql)
        results = cursor.fetchall()
        db.close()
        return results
    except Exception as e:
        print(e)


def get_all_3tag_2tag():
    try:
        sql = "select a.child_id,a.parent_id from api_tagrelation a" \
              " left join api_tag b on a.parent_id=b.id " \
              "where a.child_id in (select id from api_tag where tag_type='3' and is_online=1) " \
              "and b.tag_type='2' and b.is_online=1"
        mysql_results = get_data_by_mysql('172.16.30.141', 3306, 'work', 'BJQaT9VzDcuPBqkd', 'zhengxing', sql)
        result_dict = dict()
        for data in mysql_results:
            if data['child_id'] not in result_dict:
                result_dict[data['child_id']] = [data['parent_id']]
            else:
                result_dict[data['child_id']].append(data['parent_id'])
        return result_dict
    except Exception as e:
        print(e)


def get_all_3tag_1tag():
    try:
        sql = "select a.child_id,a.parent_id from api_tagrelation a" \
              " left join api_tag b on a.parent_id=b.id " \
              "where a.child_id in (select id from api_tag where tag_type='3' and is_online=1) " \
              "and b.tag_type='1' and b.is_online=1"
        mysql_results = get_data_by_mysql('172.16.30.141', 3306, 'work', 'BJQaT9VzDcuPBqkd', 'zhengxing', sql)
        result_dict = dict()
        for data in mysql_results:
            if data['child_id'] not in result_dict:
                result_dict[data['child_id']] = [data['parent_id']]
            else:
                result_dict[data['child_id']].append(data['parent_id'])
        return result_dict
    except Exception as e:
        print(e)


def get_all_2tag_1tag():
    try:
        sql = "select a.child_id,a.parent_id from api_tagrelation a" \
              " left join api_tag b on a.parent_id=b.id " \
              "where a.child_id in (select id from api_tag where tag_type='2' and is_online=1) " \
              "and b.tag_type='1' and b.is_online=1"
        mysql_results = get_data_by_mysql('172.16.30.141', 3306, 'work', 'BJQaT9VzDcuPBqkd', 'zhengxing', sql)
        result_dict = dict()
        for data in mysql_results:
            if data['child_id'] not in result_dict:
                result_dict[data['child_id']] = [data['parent_id']]
            else:
                result_dict[data['child_id']].append(data['parent_id'])
        return result_dict
    except Exception as e:
        print(e)


def get_all_tag_tag_name():
    try:
        sql = "select id,name from api_tag where is_online=1 and tag_type+0 < '4'+0"
        mysql_results = get_data_by_mysql('172.16.30.141', 3306, 'work', 'BJQaT9VzDcuPBqkd', 'zhengxing', sql)
        result_dict = dict()
        for data in mysql_results:
            result_dict[data['id']] = data['name']
        return result_dict
    except Exception as e:
        print(e)


def get_all_tag_result():
    try:
        sql = "select a.id,a.name,a.tag_type,count(b.service_id) as service_count from api_tag a " \
              "left join api_servicetag b on a.id=b.tag_id " \
              "left join api_service c on b.service_id = c.id " \
              "where a.is_online=1 and a.tag_type+0<'4'+0 and c.is_online=1 " \
              "group by a.id order by count(b.service_id) desc"
        mysql_results = get_data_by_mysql('172.16.30.141', 3306, 'work', 'BJQaT9VzDcuPBqkd', 'zhengxing', sql)
        return pd.DataFrame(mysql_results)
    except Exception as e:
        print(e)

all_3tag_2tag = get_all_3tag_2tag()
all_3tag_1tag = get_all_3tag_1tag()
all_2tag_1tag = get_all_2tag_1tag()
all_tag_tag_name = get_all_tag_tag_name()

result1 = get_all_tag_result()
result1['tag1_ids'] = ''
result1['tag1_names'] = ''
result1['tag2_ids'] = ''
result1['tag2_names'] = ''


result2 = pd.DataFrame(columns=list(result1.columns))
for index, row in result1.iterrows():
    if int(row['tag_type']) == 2:
        row['tag1_ids'] = str(all_2tag_1tag.get(int(row['id']), ''))
        row['tag1_names'] = str([all_tag_tag_name[i] for i in all_2tag_1tag.get(int(row['id']), '')])
        result2 = result2.append(row, ignore_index=True)
    elif int(row['tag_type']) == 3:
        row['tag1_ids'] = str(all_3tag_1tag.get(int(row['id']), ''))
        row['tag1_names'] = str([all_tag_tag_name[i] for i in all_3tag_1tag.get(int(row['id']), '')])
        row['tag2_ids'] = str(all_3tag_2tag.get(int(row['id']), ''))
        row['tag2_names'] = str([all_tag_tag_name[i] for i in all_3tag_2tag.get(int(row['id']), '')])
        result2 = result2.append(row, ignore_index=True)
    else:
        result2 = result2.append(row, ignore_index=True)
        continue
result2.to_csv("tag_stat.csv", sep=',', index=False)