from __future__ import absolute_import
from __future__ import division
from __future__ import print_function
import pymysql
import smtplib
from email.mime.text import MIMEText
from email.utils import formataddr
from email.mime.multipart import MIMEMultipart
from email.mime.application import MIMEApplication
import redis
import datetime
from pyspark import SparkConf
import time
from pyspark.sql import SparkSession
import json
import numpy as np
import pandas as pd
from pyspark.sql.functions import lit
from pyspark.sql.functions import concat_ws


def send_email(app,id,e):
    # 第三方 SMTP 服务
    mail_host = 'smtp.exmail.qq.com'  # 设置服务器
    mail_user = "gaoyazhe@igengmei.com"  # 用户名
    mail_pass = "VCrKTui99a7ALhiK"  # 口令

    sender = 'gaoyazhe@igengmei.com'
    receivers = ['gaoyazhe@igengmei.com']  # 接收邮件，可设置为你的QQ邮箱或者其他邮箱
    e = str(e)
    msg = MIMEMultipart()
    part = MIMEText('app_id:'+id+':fail', 'plain', 'utf-8')
    msg.attach(part)
    msg['From'] = formataddr(["gaoyazhe", sender])
    # 括号里的对应收件人邮箱昵称、收件人邮箱账号
    msg['To'] = ";".join(receivers)
    # message['Cc'] = ";".join(cc_reciver)

    msg['Subject'] = 'spark streaming:app_name:'+app
    with open('error.txt','w') as f:
         f.write(e)
         f.close()
    part = MIMEApplication(open('error.txt', 'r').read())
    part.add_header('Content-Disposition', 'attachment', filename="error.txt")
    msg.attach(part)

    try:
        smtpObj = smtplib.SMTP_SSL(mail_host, 465)
        smtpObj.login(mail_user, mail_pass)
        smtpObj.sendmail(sender, receivers, msg.as_string())
    except smtplib.SMTPException:
        print('error')


def get_user_history_order_service_tag(user_id, stat_date):
    try:
        if user_id:
            db_zhengxing = pymysql.connect(host="172.16.30.141", port=3306, user="work",
                                           password="BJQaT9VzDcuPBqkd",
                                           db="zhengxing", cursorclass=pymysql.cursors.DictCursor)
            cur_zhengxing = db_zhengxing.cursor()

            sql = "select a.tag_id from api_servicetag a left join api_tag b on a.tag_id=b.id " \
                  "where a.service_id in (select service_id from api_order where user_id={user_id} and status=1) " \
                  "and b.tag_type+0 <'4'+0 ".format(user_id=user_id)
            cur_zhengxing.execute(sql)
            tags_dict = cur_zhengxing.fetchall()
            tags_list = [i["tag_id"] for i in tags_dict]
            # 写gmkv
            gm_kv_cli = redis.Redis(host="172.16.40.135", port=5379, db=2, socket_timeout=2000)
            user_history_order_tags_key = "user:history_order:tags:user_id:" + str(user_id)
            tags_list_json = json.dumps(tags_list)
            gm_kv_cli.set(user_history_order_tags_key, tags_list_json)
            gm_kv_cli.expire(user_history_order_tags_key, time=30 * 24 * 60 * 60)
            # 写tidb
            sql_cl_id = "select device_id from statistic_device where id = (select max(device_id) from statistic_device_user where user_id = %d) " % (int(user_id))
            cur_zhengxing.execute(sql_cl_id)
            cl_id = cur_zhengxing.fetchall()[0]["device_id"]

            db_jerry_test = pymysql.connect(host='172.16.40.158', port=4000, user='root', passwd='3SYz54LS9#^9sBvC',
                                            db='jerry_test', charset='utf8')
            cur_jerry_test = db_jerry_test.cursor()
            replace_sql = """replace into user_history_order_tags (stat_date, cl_id, user_id, tag_list) values("{stat_date}","{cl_id}",{user_id},"{tag_list}")"""\
                .format(stat_date=stat_date, cl_id=cl_id, user_id=user_id, tag_list=tags_list)
            cur_jerry_test.execute(replace_sql)
            db_jerry_test.commit()
            db_jerry_test.close()
            return 'sucess'
    except Exception as e:
        return 'pass'


if __name__ == '__main__':
    try:
        db_zhengxing = pymysql.connect(host="172.16.30.141", port=3306, user="work",
                                       password="BJQaT9VzDcuPBqkd",
                                       db="zhengxing", cursorclass=pymysql.cursors.DictCursor)
        cur_zhengxing = db_zhengxing.cursor()

        # 获取所有用户的设备id
        sql_device_ids = "select distinct user_id from api_order where status=1 and pay_time>'2015-08-16'"
        cur_zhengxing.execute(sql_device_ids)
        device_ids_lst = [i["user_id"] for i in cur_zhengxing.fetchall()]
        stat_date = datetime.datetime.today().strftime('%Y-%m-%d')

        # rdd
        sparkConf = SparkConf().set("spark.hive.mapred.supports.subdirectories", "true") \
            .set("spark.hadoop.mapreduce.input.fileinputformat.input.dir.recursive", "true") \
            .set("spark.tispark.plan.allow_index_double_read", "false") \
            .set("spark.tispark.plan.allow_index_read", "true") \
            .set("spark.sql.extensions", "org.apache.spark.sql.TiExtensions") \
            .set("spark.tispark.pd.addresses", "172.16.40.170:2379").set("spark.io.compression.codec", "lzf") \
            .set("spark.driver.maxResultSize", "8g").set("spark.sql.avro.compression.codec", "snappy")

        spark = SparkSession.builder.config(conf=sparkConf).enableHiveSupport().getOrCreate()
        spark.sparkContext.setLogLevel("WARN")

        device_ids_lst_rdd = spark.sparkContext.parallelize(device_ids_lst)
        result = device_ids_lst_rdd.repartition(100).map(lambda x: get_user_history_order_service_tag(x, stat_date))
        result.collect()

    except Exception as e:
        send_email("dist_update_user_history_order_tags", "dist_update_user_history_order_tags", "")