/*
 * Decompiled with CFR 0.152.
 */
package com.soundcloud.lsh;

import com.soundcloud.lsh.Lsh;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.IndexedRow;
import org.apache.spark.mllib.linalg.distributed.IndexedRowMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Main$ {
    public static final Main$ MODULE$;

    static {
        new Main$();
    }

    public void main(String[] args) {
        int numPartitions = 8;
        String input = "data/example.tsv";
        SparkConf conf = new SparkConf().setAppName("LSH-Cosine").setMaster("local[4]");
        StorageLevel storageLevel = StorageLevel$.MODULE$.MEMORY_AND_DISK();
        SparkContext sc = new SparkContext(conf);
        RDD data = sc.textFile(input, numPartitions).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, double[]> apply(String line) {
                String[] split = line.split(" ");
                String word = (String)Predef$.MODULE$.refArrayOps((Object[])split).head();
                double[] features = (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])split).tail()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(String x$1) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                return new Tuple2((Object)word, (Object)features);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD indexed = data.zipWithIndex().persist(storageLevel);
        RDD rows = indexed.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IndexedRow apply(Tuple2<Tuple2<String, double[]>, Object> x0$1) {
                Tuple2<Tuple2<String, double[]>, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    long index = tuple2._2$mcJ$sp();
                    if (tuple22 != null) {
                        double[] features = (double[])tuple22._2();
                        IndexedRow indexedRow = new IndexedRow(index, Vectors$.MODULE$.dense(features));
                        return indexedRow;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(IndexedRow.class));
        RDD index = indexed.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, String> apply(Tuple2<Tuple2<String, double[]>, Object> x0$2) {
                Tuple2<Tuple2<String, double[]>, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    long index = tuple2._2$mcJ$sp();
                    if (tuple22 != null) {
                        String word = (String)tuple22._1();
                        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToLong((long)index), (Object)word);
                        return tuple23;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).persist(storageLevel);
        IndexedRowMatrix matrix = new IndexedRowMatrix(rows);
        Lsh lsh = new Lsh(0.5, 20, 200, 10, numPartitions, storageLevel);
        CoordinateMatrix similarityMatrix = lsh.join(matrix);
        RDD remapFirst = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(similarityMatrix.entries().keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(MatrixEntry x$2) {
                return x$2.i();
            }
        }), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(MatrixEntry.class), (Ordering)Ordering.Long$.MODULE$).join(index), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).values();
        RDD remapSecond = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(remapFirst.keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<MatrixEntry, String> x0$3) {
                Tuple2<MatrixEntry, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    MatrixEntry entry = (MatrixEntry)tuple2._1();
                    long l = entry.j();
                    return l;
                }
                throw new MatchError(tuple2);
            }
        }), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).join(index), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).values().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<String, String, Object> apply(Tuple2<Tuple2<MatrixEntry, String>, String> x0$4) {
                Tuple2<Tuple2<MatrixEntry, String>, String> tuple2 = x0$4;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    String word2 = (String)tuple2._2();
                    if (tuple22 != null) {
                        MatrixEntry entry = (MatrixEntry)tuple22._1();
                        String word1 = (String)tuple22._2();
                        Tuple3 tuple3 = new Tuple3((Object)word1, (Object)word2, (Object)BoxesRunTime.boxToDouble((double)entry.value()));
                        return tuple3;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        RDD result = remapSecond.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple3<String, String, Object> x$3) {
                return (String)x$3._1();
            }
        }, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Iterable<Tuple3<String, String, Object>>> x0$5) {
                Tuple2<String, Iterable<Tuple3<String, String, Object>>> tuple2 = x0$5;
                if (tuple2 != null) {
                    String word1 = (String)tuple2._1();
                    Iterable similarWords = (Iterable)tuple2._2();
                    String similar = ((TraversableOnce)((TraversableLike)((IterableLike)similarWords.toSeq().sortBy((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply(Tuple3<String, String, Object> x$4) {
                            return (double)-1 * BoxesRunTime.unboxToDouble((Object)x$4._3());
                        }
                    }, (Ordering)Ordering.Double$.MODULE$)).take(10)).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple3<String, String, Object> x$5) {
                            return (String)x$5._2();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(",");
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " --> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{word1, similar}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(String.class));
        Predef$.MODULE$.refArrayOps((Object[])result.take(20)).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        sc.stop();
    }

    private Main$() {
        MODULE$ = this;
    }
}

