import argparse
import pymeshio.common
import pymeshio.obj.reader
import math
import numpy as np
def get_args():
    parser = argparse.ArgumentParser(description="This script calculate the angle between two lines",
                                     formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument("--index", "-i", type=str, required=True,
                        help="indexes of 4 points in the 68 points")
    parser.add_argument("--plane", "-p", type=str, default='3d',required=True,
                        help="coodinate plane to calculate")
    args = parser.parse_args()
    return args

if __name__ == '__main__':
   args=get_args()
   plane=args.plane
   index=args.index
   #print(index)
   index=np.fromstring(index, dtype=int, sep=' ')
   #print(index[0])
   OBJ_FILE=pymeshio.common.unicode("../data/landmark68.obj")
   model=pymeshio.obj.reader.read_from_file(OBJ_FILE)
   #plane=args.plane
   a=model.vertices[int(index[0])]
   b=model.vertices[int(index[1])]
   if plane=='xy':
      #print(int(a.x))
      vec_a=np.array([a.x,a.y])
      vec_b=np.array([b.x,b.y])
      #dist=np.sqrt(np.sum(np.square(vec_a-vec_b)))
      #print(dist)
   if plane=='xz':
      vec_a=np.array([a.x,a.z])
      vec_b=np.array([b.x,b.z])
   if plane=='yz':
      vec_a=np.array([a.y,a.z])
      vec_b=np.array([b.y,b.z])
   if plane=='3d':
      vec_a=np.array([float(a.x),float(a.y),float(a.z)])
      vec_b=np.array([float(b.x),float(b.y),float(b.z)])
   
   dist=np.sqrt(np.sum(np.square(vec_a-vec_b)))
   print("[",plane,"_dist:",dist,"]")
      
