# coding:utf-8
# author:Thierry
from .base_part import BasePart


class Nose(BasePart):
    """
    鼻部模型
    """

    CATEGORIES = ['normal', 'wide']
    def __init__(self,roll_rand,**kwargs):
        super(Nose,self).__init__(roll_rand,**kwargs)
        self.left_eye_right_corner=self.p_39
        self.nose_left=self.p_31
        self.right_eye_left_corner=self.p_42
        self.nose_right=self.p_35
    def attrs(self):
        return (
            'p_31',
            'p_35',
            'p_39',
            'p_42',
        )

    def get_vector(self):
        return [self._wing_root_ratio()]

    def _wing_root_ratio(self):
        return self._wing_width() / self._root_width()

    def _root_width(self):
        """
        内眼角的宽度
        """
        return self.left_eye_right_corner['x'] - self.right_eye_left_corner['x']

    def _wing_width(self):
        """
        鼻翼的宽度
        """
        return self.nose_right['x'] - self.nose_left['x']
