import argparse
import pymeshio.common
import pymeshio.obj.reader
import math
import numpy as np
def get_args():
    parser = argparse.ArgumentParser(description="This script calculate the angle between two lines",
                                     formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument("--index", "-i", type=str, required=True,
                        help="indexes of 4 points in the 68 points")
    parser.add_argument("--plane", "-p", type=str, default='all',required=True,
                        help="coodinate plane to calculate")
    args = parser.parse_args()
    return args

def get_k(pt_1,pt_2,plane):
       
    if pt_1 and pt_2:
      if plane=='all':
        delta_x=abs(pt_1.x-pt_2.x)
        delta_y=abs(pt_1.y-pt_2.y)
        delta_z=abs(pt_1.z-pt_2.z)
        k_sets=[]
        if delta_x==0:
            k_xy=None
            k_xz=None
        if delta_y==0:
            k_yz=None
        if delta_y==0 and delta_x!=0:
            k_xy=0
        if delta_z==0 and delta_x!=0:
            k_xz=0
        if delta_z==0 and delta_y!=0:
            k_yz=0
        if delta_x!=0 and delta_y!=0:
            k_xy=delta_y/delta_x
            k_sets.append(k_xy)
        if delta_x!=0 and delta_z!=0:
            k_xz=delta_z/delta_x
            k_sets.append(k_xz)
        if delta_y!=0 and delta_z!=0:
            k_yz=delta_z/delta_y
            k_sets.append(k_yz)
        return k_sets
      if plane=='xy':
        delta_x=abs(pt_1.x-pt_2.x)
        delta_y=abs(pt_1.y-pt_2.y)
        if delta_x==0:
            k=None
        if delta_y==0 and delta_x!=0:
            k=0
        if delta_x!=0 and delta_y!=0:
            k=delta_y/delta_x
        return k

      if plane=='yz':
        delta_z=abs(pt_1.z-pt_2.z)
        delta_y=abs(pt_1.y-pt_2.y)
        if delta_y==0:
            k=None
        if delta_z==0 and delta_y!=0:
            k=0
        if delta_z!=0 and delta_y!=0:
            k=delta_z/delta_y
        return k

      if plane=='xz':
        delta_z=abs(pt_1.z-pt_2.z)
        delta_x=abs(pt_1.x-pt_2.x)
        if delta_x==0:
            k=None
        if delta_z==0 and delta_x!=0:
            k=0
        if delta_z!=0 and delta_x!=0:
            k=delta_z/delta_x
        return k

def point2angle(pts,plane):
    if len(pts)!=4:
       print("failed to get all the four points")
       return None
    if plane=='xy' or plane=='yz' or plane=='xz':
       k1=get_k(pts[0],pts[1],plane)
       k2=get_k(pts[2],pts[3],plane)
       if k1!=None and k2!=None:
           tan_theta=abs((k1-k2)/(1+k1*k2))
           return math.atan(tan_theta)
       else:
           return None
    else:
       k1_sets=get_k(pts[0],pts[1],plane)
       k1_xy=k1_sets[0]
       k1_xz=k1_sets[1]
       k1_yz=k1_sets[2]

       k2_sets=get_k(pts[2],pts[3],plane)
       k2_xy=k2_sets[0]
       k2_xz=k2_sets[1]
       k2_yz=k2_sets[2]
       
       theta_set=[]
       if k1_xy!=None and k2_xy!=None and k1_yz!=None and k2_yz!=None and k1_xz!=None and k2_xz!=None:
           tan_xy=abs((k1_xy-k2_xy)/(1+k1_xy*k2_xy))
           theta_xy=math.atan(tan_xy)
           tan_xz=abs((k1_xz-k2_xz)/(1+k1_xz*k2_xz))
           theta_xz=math.atan(tan_xz)
           tan_yz=abs((k1_yz-k2_yz)/(1+k1_yz*k2_yz))
           theta_yz=math.atan(tan_yz)
           theta_set=(theta_xy,theta_xz,theta_yz)
if __name__ == '__main__':
    args=get_args()
    index=args.index
    index=np.fromstring(index, dtype=int, sep=' ')
    plane=args.plane
    OBJ_FILE=pymeshio.common.unicode("../data/landmark68.obj")
    model=pymeshio.obj.reader.read_from_file(OBJ_FILE)
    #print(len(model.vertices))
    
    a=model.vertices[int(index[0])]
    b=model.vertices[int(index[1])]
    c=model.vertices[int(index[2])]
    d=model.vertices[int(index[3])]
    pts=(a,b,c,d)
    #print(pts)
    if plane=='all':
       angle_xy=point2angle(pts,'xy')
       angle_yz=point2angle(pts,'yz')
       angle_xz=point2angle(pts,'xz')
       print("[xy:",angle_xy,"yz:",angle_yz,"xz:",angle_xz,"]")
    
    else:
       angle=point2angle(pts,plane)
       print("[",plane,":",angle,"]")
   


