# coding:utf-8
# author:Thierry
import math
from .base_part import BasePart


class Eye(BasePart):
    """
    眼部模型
    """

    CATEGORIES = ['danfeng', 'xingren', 'xiachui', 'xichang']
    def __init__(self,roll_rand,**kwargs):
        super(Eye,self).__init__(roll_rand,**kwargs)
        self.left_eye_bottom=self.p_47
        self.left_eye_right_corner=self.p_45
        self.left_eye_left_corner=self.p_42
        self.left_eye_top=self.p_43
    def attrs(self):
        return (
            'p_42',
            'p_43',
            'p_44',
            'p_45',
            'p_46',
            'p_47',
        )

    def get_vector(self):
        #print('vector result',self.inner_upper_rand())
        return [
            self.inner_upper_rand(),
            self.top_inner_outer_rand(),
            self.bottom_inner_outer_rand(),
            self.inner_top_bottom_rand(),
            self.outer_top_bottom_rand()
        ]

    def inner_upper_rand(self):
        """
        内外眼角上挑的弧度（值越大，越趋近丹凤眼）
        """
        adjacent = self.left_eye_right_corner['x'] - self.left_eye_left_corner['x']
        opposite = self.left_eye_right_corner['y'] - self.left_eye_left_corner['y']
        #print('a',adjacent,'opp',opposite)
        return math.atan2(opposite, adjacent) - self.roll_rand

    def top_inner_outer_rand(self):
        """
        眼顶部中心和内外眼角的夹角
        """
        # 顶部内夹角
        inner_opposite = self.left_eye_right_corner['x'] - self.left_eye_top['x']
        inner_adjacent = self.left_eye_right_corner['y'] - self.left_eye_top['y']
        inner_rand = math.atan2(inner_opposite, inner_adjacent)

        # 顶部外夹角
        outer_opposite = self.left_eye_top['x'] - self.left_eye_left_corner['x']
        outer_adjacent = self.left_eye_left_corner['y'] - self.left_eye_top['y']
        outer_rand = math.atan2(outer_opposite, outer_adjacent)

        return inner_rand + outer_rand

    def bottom_inner_outer_rand(self):
        """
        眼底部的和内外眼角的夹角
        """
        # 底部内夹角
        inner_opposite = self.left_eye_right_corner['x'] - self.left_eye_bottom['x']
        inner_adjacent = self.left_eye_bottom['y'] - self.left_eye_right_corner['y']
        inner_rand = math.atan2(inner_opposite, inner_adjacent)

        # 底部外夹角
        outer_opposite = self.left_eye_bottom['x'] - self.left_eye_left_corner['x']
        outer_adjacent = self.left_eye_bottom['y'] - self.left_eye_left_corner['y']
        outer_rand = math.atan2(outer_opposite, outer_adjacent)

        return inner_rand + outer_rand

    def inner_top_bottom_rand(self):
        """
        内眼角和顶部底部的夹角
        """
        # 内眼角与顶部夹角
        top_opposite = self.left_eye_right_corner['y'] - self.left_eye_top['y']
        top_adjacent = self.left_eye_right_corner['x'] - self.left_eye_top['x']
        top_rand = math.atan2(top_opposite, top_adjacent)

        # 内眼角与底部夹角
        bottom_opposite = self.left_eye_bottom['y'] - self.left_eye_right_corner['y']
        bottom_adjacent = self.left_eye_right_corner['x'] - self.left_eye_bottom['x']
        bottom_rand = math.atan2(bottom_opposite, bottom_adjacent)

        return top_rand + bottom_rand

    def outer_top_bottom_rand(self):
        """
        外眼角和顶部底部的夹角
        """
        # 外眼角与顶部夹角
        top_opposite = self.left_eye_left_corner['y'] - self.left_eye_top['y']
        top_adjacent = self.left_eye_top['x'] - self.left_eye_left_corner['x']
        top_rand = math.atan2(top_opposite, top_adjacent)

        # 外眼角与底部夹角
        bottom_opposite = self.left_eye_bottom['y'] - self.left_eye_left_corner['y']
        bottom_adjacent = self.left_eye_bottom['x'] - self.left_eye_left_corner['x']
        bottom_rand = math.atan2(bottom_opposite, bottom_adjacent)

        return top_rand + bottom_rand

    def aspect_ratio(self):
        """
        宽高比（值越大，越圆）
        """
        return float(self._width()) / float(self._height())

    def _height(self):
        return self.left_eye_bottom['y'] - self.left_eye_top['y']

    def _width(self):
        return self.left_eye_right_corner['x'] - self.left_eye_left_corner['x']
