# coding:utf-8
# author:Thierry
from __future__ import division
import math

from .base_part import BasePart

import numpy as np

class Contour(BasePart):
    """
    面部轮廓模型
    """
    # 圆脸,鹅蛋,尖脸,方脸
    CATEGORIES = ['round', 'oval', 'heart', 'square']
    def __init__(self,roll_rand,**kwargs):
        super(Contour,self).__init__(roll_rand,**kwargs)
        self.contour_left1=self.p_0
        self.contour_left2=self.p_0
        self.contour_left3=self.p_1
        self.contour_left4=self.p_2
        self.contour_left5=self.p_3
        self.contour_left6=self.p_4
        self.contour_left7=self.p_5
        self.contour_left8=self.p_6
        self.contour_left9=self.p_7
   
        self.contour_chin=self.p_8

        self.contour_right1=self.p_16
        self.contour_right2=self.p_16
        self.contour_right3=self.p_15
        self.contour_right4=self.p_14
        self.contour_right5=self.p_13
        self.contour_right6=self.p_12
        self.contour_right7=self.p_11
        self.contour_right8=self.p_10
        self.contour_right9=self.p_9

    def attrs(self):
        return (
        'p_0',
        'p_1',
        'p_2',
        'p_3',
        'p_4',
        'p_5',
        'p_6',
        'p_7',
        'p_8',
        'p_9',
        'p_10',
        'p_11',
        'p_12',
        'p_13',
        'p_14',
        'p_15',
        'p_16',
        'p_19',
        'p_24'
        )

    def get_vector(self):
        result=self.slopes()
        result+=self.face_chin_angle_plus()
        result.append(self.width_height_ratio())
        result.append(self.chin_bottom_angle())
        print('re',result)
        return result
 
    @property
    def base_slope(self):
        """
        base slope: 基准斜率
        :return:
        """
        return (self.slope_abs(self.contour_left1, self.contour_chin) +
                self.slope_abs(self.contour_right1, self.contour_chin)) / 2

    def slope_abs(self, point1, point2):
        """
        absolute value of slope.
        :param point1:
        :param point2:
        :return:
        """
        return math.atan(abs((point1['y'] - point2['y']) / (point1['x'] - point2['x'])))

    def slopes(self):
        """将相关的点拟合成抛物线，计算曲率"""
        slopes = []
        for i in range(3, 10):
            s1 = self.slope_abs(getattr(self, 'contour_left' + str(i)), self.contour_chin)
            s2 = self.slope_abs(getattr(self, 'contour_right' + str(i)), self.contour_chin)
            slopes.append((s1 + s2) / (2 * self.base_slope))
        return slopes
    
    def distance(self,pt1,pts):
        dist=np.sqrt(np.square(pt1['x']-pt2['x'])+np.square(pt1['y']-pt2['y']))
        #print('dist:',dist)
    
    def face_chin_width_ratio(self):
        face_w=np.sqrt((self.p_0['x']-self.p_16['x'])**2+(self.p_0['y']-self.p_16['y'])**2)
        chin_w=np.sqrt((self.p_4['x']-self.p_12['x'])**2+(self.p_4['y']-self.p_12['y'])**2)
        #face_w=distance(self.p_0,self.p_16)
        #chin_w=distance(self.p_4,self.p_12)
        ratio=chin_w/face_w
        #ratio=(face_w/chin_w-1)
        #print('chin width ratio:',ratio)
        return ratio
    
    def width_height_ratio(self):
        center={}
        center['x']=0.5*(self.p_19['x']+self.p_24['x'])
        center['y']=0.5*(self.p_19['y']+self.p_24['y'])
        face_w=np.sqrt((self.p_0['x']-self.p_16['x'])**2+(self.p_0['y']-self.p_16['y'])**2)
        face_h=np.sqrt((self.p_8['x']-center['x'])**2+(self.p_8['y']-center['y'])**2)
         
        return face_w/face_h
    
    def chin_slopes(self):
        #print('chin slopes')
        s1 = self.slope_abs(self.contour_left4, self.contour_left7)
        s2 = self.slope_abs(self.contour_right4, self.contour_right7)
        s3 = self.slope_abs(self.contour_left8, self.contour_chin)
        s4 = self.slope_abs(self.contour_right8, self.contour_chin)
#print('s1 s2:',s1,s2)
        slopes=[s1,s2,s3,s4]
        #print('slopes:',slopes)
        return slopes


    def face_chin_angle(self):
         
        BA = [
            self.p_4['x'] - self.p_0['x'],
            self.p_4['y'] - self.p_0['y']
        ]

        BC = [
            self.p_4['x'] - self.p_7['x'],
            self.p_4['y'] - self.p_7['y']
        ]

        cosin_0 = (
            (BA[0] * BC[0] + BA[1] * BC[1]) /
            (math.sqrt(BA[0] ** 2 + BA[1] ** 2) * math.sqrt(BC[0] ** 2) + BC[1] ** 2)
        )

        BA_R = [
            self.p_16['x'] - self.p_12['x'],
            self.p_16['y'] - self.p_12['y']
        ]

        BC_R = [
            self.p_16['x'] - self.p_9['x'],
            self.p_16['y'] - self.p_9['y']
        ]

        cosin_1 = (
            (BA_R[0] * BC_R[0] + BA_R[1] * BC_R[1]) /
            (math.sqrt(BA_R[0] ** 2 + BA_R[1] ** 2) * math.sqrt(BC_R[0] ** 2) + BC_R[1] ** 2)
        )
        return [cosin_0,cosin_1]
    
    def face_chin_angle_plus(self):
       k1=self.slope_abs(self.p_1,self.p_4)
       k2=self.slope_abs(self.p_7,self.p_4)
       angle1=abs((k2-k1)/(1+k1*k2)) 
       
       k3=self.slope_abs(self.p_15,self.p_12)
       k4=self.slope_abs(self.p_9,self.p_12)
       angle2=abs((k4-k3)/(1+k3*k4)) 
       
       k5=self.slope_abs(self.p_6,self.p_7)
       k6=self.slope_abs(self.p_9,self.p_10)
       angle3=abs((k5-k6)/(1+k5*k6)) 
       return [angle1,angle2,angle3]
    
    def chin_bottom_angle(self):
        left=self.slope_abs(self.p_7,self.p_8)
        right=self.slope_abs(self.p_9,self.p_8)
        angle=abs((left-right)/(1+left*right))
        return angle

