# Contributing to Detectron
We want to make contributing to this project as easy and transparent as
possible.

## Our Development Process
Minor changes and improvements will be released on an ongoing basis. Larger
changes (e.g., changesets implementing a new paper) will be released on a more
periodic basis.

## Pull Requests
We actively welcome your pull requests.

1. Fork the repo and create your branch from `master`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code lints.
6. Ensure no regressions in baseline model speed and accuracy.
7. If you haven't already, complete the Contributor License Agreement ("CLA").

## Contributor License Agreement ("CLA")
In order to accept your pull request, we need you to submit a CLA. You only need
to do this once to work on any of Facebook's open source projects.

Complete your CLA here: <https://code.facebook.com/cla>

## Issues
GitHub issues will be largely unattended and are mainly intended as a community
forum for collectively debugging issues, hopefully leading to pull requests with
fixes when appropriate.

## Coding Style  
* 4 spaces for indentation rather than tabs
* 80 character line length
* PEP8 formatting

## License
By contributing to Detectron, you agree that your contributions will be licensed
under the LICENSE file in the root directory of this source tree.
