# coding: utf-8
# author: gushitong
from __future__ import division

import math
import numpy as np
from base_part import BasePart

from sklearn import preprocessing


class Chin(BasePart):
    """
    下巴模型
    """
    CATEGORIES = ['sharp', 'round', 'square']
    def __init__(self,**kwargs):
        super(Chin,self).__init__(**kwargs)
        self.contour_left1=self.p_0
        self.contour_left6=self.p_12
        self.contour_left7=self.p_13
        self.contour_left8=self.p_14
        self.contour_left9=self.p_15
        self.contour_chin=self.p_16
        self.contour_right1=self.p_32
        self.contour_right6=self.p_20
        self.contour_right7=self.p_19
        self.contour_right8=self.p_18
        self.contour_right9=self.p_17
 
    def get_vector(self):
        result=[]
        result=self.chin_baseline_angle()
        angle=self.chin_bottom_angle()
        result.append(angle)
        normalized= preprocessing.normalize(result).reshape(1,-1)
        return result

    def attrs(self):
        return (
        'p_0',
        'p_12',
        'p_13',
        'p_14',
        'p_15',
        'p_16',
        'p_17',
        'p_18',
        'p_19',
        'p_20',
        'p_32',
        )

    @property
    def base_slope(self):
        """
        base slope: 基准斜率
        :return:
        """
        return (self.slope_abs(self.contour_left1, self.contour_chin) +
                self.slope_abs(self.contour_right1, self.contour_chin)) / 2

    def slope_abs(self, point1, point2):
        """
        absolute value of slope.
        :param point1:
        :param point2:
        :return:
        """
        return math.atan(abs((point1['y'] - point2['y']) / (point1['x'] - point2['x'])))

    def slopes(self):
        """将相关的点拟合成抛物线，计算曲率"""
        slopes = []
        for i in range(6, 10):
            s1 = self.slope_abs(getattr(self, 'contour_left' + str(i)), self.contour_chin)
            s2 = self.slope_abs(getattr(self, 'contour_right' + str(i)), self.contour_chin)
            slopes.append((s1 + s2) / (2 * self.base_slope))
        return slopes

    def chin_slopes(self):
        slopes_l=[]
        slopes_r=[]
        slopes=[]
        for i in range(6,9):
            s1 = self.slope_abs(getattr(self, 'contour_left' + str(i)), self.contour_chin)
            s2 = self.slope_abs(getattr(self, 'contour_right' + str(i)), self.contour_chin)
            slopes_l.append(s1)
            slopes_r.append(s2)
        slopes=slopes_l+slopes_r
        return slopes           

    def chin_baseline_angle(self):
        #baseline
        base=self.slope_abs(self.p_15,self.p_17)
        left=self.slope_abs(self.p_13,self.p_16)
        right=self.slope_abs(self.p_19,self.p_16)
        angle_left=abs((left-base)/(1+left*base))
        angle_right=abs((right-base)/(1+right*base))
        return [angle_left,angle_right]

    def chin_bottom_angle(self):
        left=self.slope_abs(self.p_13,self.p_16)
        right=self.slope_abs(self.p_19,self.p_16)
        angle=abs((left-right)/(1+left*right))
        return angle

    def face_chin_width_ratio(self):
        face_w=np.sqrt((self.p_0['x']-self.p_16['x'])**2+(self.p_0['y']-self.p_16['y'])**2)
        chin_w=np.sqrt((self.p_4['x']-self.p_12['x'])**2+(self.p_4['y']-self.p_12['y'])**2)
        #face_w=distance(self.p_0,self.p_16)
        #chin_w=distance(self.p_4,self.p_12)
        ratio=chin_w/face_w
        #ratio=(face_w/chin_w-1)
        return ratio
    
