# coding:utf-8
# author:Thierry
import math
from base_part import BasePart
import array
from sklearn import preprocessing

def dotproduct(v1, v2):
    return sum((a*b) for a, b in zip(v1, v2))

def length(v):
    return math.sqrt(dotproduct(v, v))


class Eye(BasePart):

    def __init__(self,**kwargs):
        super(Eye,self).__init__(**kwargs)
        self.left_eye_bottom=self.p_66
        self.left_eye_right_corner=self.p_64
        self.left_eye_left_corner=self.p_60
        self.left_eye_top=self.p_62
    def attrs(self):
        return (
            'p_60',  #left eye
            'p_61',
            'p_62',
            'p_63',
            'p_64',
            'p_65',
            'p_66',
            'p_67',
            'p_68',  #right eye
            'p_69',
            'p_70',
            'p_71',
            'p_72',
            'p_73',
            'p_74',
            'p_75',
            'p_96', #pupil
            'p_97'
        )

    def get_vector(self):
        v = [self.inner_angle(),
             self.top_inner_outer_rand(),
             self.inner_top_bottom_rand(),
             self.aspect_ratio()
             ]
        normalized= preprocessing.normalize(v).reshape(1,-1)
        return normalized
        
    def inner_angle(self):
        '''
        inner corner angle
        '''
        a = [self.p_63['x'],self.p_63['y']]  
        b = [self.p_64['x'],self.p_64['y']]  
        v1 = [x-y for x,y in zip(a,b)]
        
        c = [self.p_65['x'],self.p_65['y']]  
        d = [self.p_64['x'],self.p_64['y']]  
        v2 = [x-y for x,y in zip(c,d)]
        
        angle =  math.acos(dotproduct(v1, v2) / (length(v1) * length(v2))) 
        return angle
    def delta_height(self):
        return (self.p_60['y'] - self.p_64['y']) 
        
    def inner_upper_rand(self):
        """
        内外眼角上挑的弧度（值越大，越趋近丹凤眼）
        """
        adjacent = self.left_eye_right_corner['x'] - self.left_eye_left_corner['x']
        opposite = self.left_eye_right_corner['y'] - self.left_eye_left_corner['y']
        #print('a',adjacent,'opp',opposite)
        return math.atan2(opposite, adjacent) - self.roll_rand

    def top_inner_outer_rand(self):
        """
        眼顶部中心和内外眼角的夹角
        """
        # 顶部内夹角
        inner_opposite = self.left_eye_right_corner['x'] - self.left_eye_top['x']
        inner_adjacent = self.left_eye_right_corner['y'] - self.left_eye_top['y']
        inner_rand = math.atan2(inner_opposite, inner_adjacent)

        # 顶部外夹角
        outer_opposite = self.left_eye_top['x'] - self.left_eye_left_corner['x']
        outer_adjacent = self.left_eye_left_corner['y'] - self.left_eye_top['y']
        outer_rand = math.atan2(outer_opposite, outer_adjacent)

        return inner_rand + outer_rand

    def bottom_inner_outer_rand(self):
        """
        眼底部的和内外眼角的夹角
        """
        # 底部内夹角
        inner_opposite = self.left_eye_right_corner['x'] - self.left_eye_bottom['x']
        inner_adjacent = self.left_eye_bottom['y'] - self.left_eye_right_corner['y']
        inner_rand = math.atan2(inner_opposite, inner_adjacent)

        # 底部外夹角
        outer_opposite = self.left_eye_bottom['x'] - self.left_eye_left_corner['x']
        outer_adjacent = self.left_eye_bottom['y'] - self.left_eye_left_corner['y']
        outer_rand = math.atan2(outer_opposite, outer_adjacent)

        return inner_rand + outer_rand

    def inner_top_bottom_rand(self):
        """
        内眼角和顶部底部的夹角
        """
        # 内眼角与顶部夹角
        top_opposite = self.left_eye_right_corner['y'] - self.left_eye_top['y']
        top_adjacent = self.left_eye_right_corner['x'] - self.left_eye_top['x']
        top_rand = math.atan2(top_opposite, top_adjacent)

        # 内眼角与底部夹角
        bottom_opposite = self.left_eye_bottom['y'] - self.left_eye_right_corner['y']
        bottom_adjacent = self.left_eye_right_corner['x'] - self.left_eye_bottom['x']
        bottom_rand = math.atan2(bottom_opposite, bottom_adjacent)

        return top_rand + bottom_rand

    def outer_top_bottom_rand(self):
        """
        外眼角和顶部底部的夹角
        """
        # 外眼角与顶部夹角
        top_opposite = self.left_eye_left_corner['y'] - self.left_eye_top['y']
        top_adjacent = self.left_eye_top['x'] - self.left_eye_left_corner['x']
        top_rand = math.atan2(top_opposite, top_adjacent)

        # 外眼角与底部夹角
        bottom_opposite = self.left_eye_bottom['y'] - self.left_eye_left_corner['y']
        bottom_adjacent = self.left_eye_bottom['x'] - self.left_eye_left_corner['x']
        bottom_rand = math.atan2(bottom_opposite, bottom_adjacent)

        return top_rand + bottom_rand

    def aspect_ratio(self):
        """
        宽高比（值越大，越圆）
        """
        return float(self._width()) / float(self._height())

    def _height(self):
        return self.left_eye_bottom['y'] - self.left_eye_top['y']

    def _width(self):
        return self.left_eye_right_corner['x'] - self.left_eye_left_corner['x']
