# coding: utf-8
# from __future__ import division
import math
from base_part import BasePart
from sklearn import preprocessing



class EyeBrow(BasePart):
    """
    眉毛模型
    """

    CATEGORIES = ['pingzhi', 'xiachui', 'liuye', 'gongxing', 'shangtiao']
    
    def __init__(self,**kwargs):
        super(EyeBrow,self).__init__(**kwargs)
        self.left_eyebrow_left_corner=self.p_33
        self.left_eyebrow_upper_left_quarter=self.p_36
        self.left_eyebrow_lower_left_quarter=self.p_39
        self.left_eyebrow_lower_middle=self.p_40
        
        self.left_eyebrow_right_corner=self.p_37
        self.left_eyebrow_lower_right_quarter=self.p_34
        self.left_eyebrow_upper_right_quarter=self.p_41
        self.left_eyebrow_upper_middle=self.p_35
      
        self.right_eyebrow_left_corner=self.p_42
        self.right_eyebrow_right_corner=self.p_46
        self.right_eyebrow_upper_middle=self.p_44
        self.right_eyebrow_upper_right_quarter=self.p_43

        self.left_0=self.p_33
        self.left_1=self.p_34
        self.left_2=self.p_35
        self.left_3=self.p_36
        self.left_4=self.p_37
        self.right_0=self.p_42
        self.right_1=self.p_43
        self.right_2=self.p_44
        self.right_3=self.p_45
        self.right_4=self.p_46

    def attrs(self):
        return (
        'p_33',
        'p_34',
        'p_35',
        'p_36',
        'p_37',
        'p_41',
        'p_42',
        'p_43',
        'p_44',
        'p_45',
        'p_46',
        'p_39',
        'p_40',
        )


    def _q_length_ratio(self):
        """眉峰 占据 整个眉长的比例."""
        al = self.left_eyebrow_right_corner['x'] - self.left_eyebrow_left_corner['x']
        bl = self.left_eyebrow_right_corner['x'] - self.left_eyebrow_upper_left_quarter['x']

        ar = self.right_eyebrow_right_corner['x'] - self.right_eyebrow_left_corner['x']
        br = self.right_eyebrow_left_corner['x'] - self.right_eyebrow_upper_right_quarter['x']

        a = abs(al) + abs(ar)
        b = abs(bl) + abs(br)
        return b / a

    def _q_length_ratio_plus(self):
        """眉峰 占据 整个眉长的比例."""
        left_high={}
        right_high={}
        if self.p_18['y']>self.p_19['y']:
           left_high['x']=self.p_18['x']
        else:
           left_high['x']=self.p_19['x']
        
        if self.p_24['y']>self.p_25['y']:
           right_high['x']=self.p_24['x']
        else:
           right_high['x']=self.p_25['x']

        al = self.p_21['x'] - left_high['x']
        bl = left_high['x'] - self.p_17['x']
        ratio_left= al/bl

        ar = right_high['x'] - self.p_22['x']
        br = self.p_26['x'] - right_high['x']
        ratio_right=ar/br
        
        return ratio_left 
    def _corner_upper_middle_angle(self):
        """
        left upper middle: B as origin
        left corner: A
        right corner: C

        return: cosin <ABC>
        """
        BA = [
            self.left_eyebrow_left_corner['x'] - self.left_eyebrow_upper_middle['x'],
            self.left_eyebrow_left_corner['y'] - self.left_eyebrow_upper_middle['y']
        ]

        BC = [
            self.left_eyebrow_right_corner['x'] - self.left_eyebrow_upper_middle['x'],
            self.left_eyebrow_right_corner['y'] - self.left_eyebrow_upper_middle['y']
        ]

        cosin = (
            (BA[0] * BC[0] + BA[1] * BC[1]) /
            (math.sqrt(BA[0] ** 2 + BA[1] ** 2) * math.sqrt(BC[0] ** 2) + BC[1] ** 2)
        )
        return cosin


    def _corner_upper_q_slope(self):
        y = self.right_eyebrow_left_corner['y'] - self.right_eyebrow_upper_right_quarter['y']
        x = self.right_eyebrow_upper_right_quarter['x'] - self.right_eyebrow_left_corner['x']
        if x==0:
           return 100
        return y / x

    def _corner_upper_q_slope_plus(self):
        yr = self.p_26['y'] - self.p_25['y']
        xr = self.p_26['x'] - self.p_25['x']
        if xr!=0:
           ratio_r=yr/xr
        else:
           ratio_r=100 
        yl = self.p_18['y'] - self.p_17['y']
        xl = self.p_18['x'] - self.p_17['x']
        if xl!=0:
           ratio_l=yl/xl
        else:
           ratio_l=100
           
        return ratio_l,ratio_r
    
    def head_middle_end_angle(self):
        s1=slope_abs(self.left_2,self.left_0)
        s2=slope_abs(self.left_4,self.left_2)
        
        s3=slope_abs(self.right_2,self.right_0)
        s4=slope_abs(self.right_4,self.right_2)

           
        return s1,s2,s3,s4

    def slope_abs(self, point1, point2):
        """
        absolute value of slope.
        :param point1:
        :param point2:
        :return:
        """
        return math.atan(abs((point1['y'] - point2['y']) / (point1['x'] - point2['x'])))

    def eyebrow_slopes(self):
        slopes=[]
        slopes_l=[]
        slopes_r=[]
        for i in range(0,5):
            if i!= 2:
               s1 = self.slope_abs(getattr(self, 'left_' + str(i)), self.left_2)
               s2 = self.slope_abs(getattr(self, 'right_' + str(i)), self.right_2)
               slopes_l.append(s1)
               slopes_r.append(s2)
        slopes=slopes_l+slopes_r
        return slopes

    def eyebrow_raw_points(self):
        return[self.left_0,self.left_1,self.left_2,self.left_3,self.left_4,self.right_0,self.right_1,self.right_2,self.right_3,self.right_4]

    def get_vector(self):
        
        result= self.eyebrow_slopes()
        angle= self._corner_upper_middle_angle()
        result.append(angle)
        result= preprocessing.normalize(result).reshape(1,-1)
        return result
