# coding: utf-8
# author: gushitong
from __future__ import division
import math

from sklearn import preprocessing
from base_part import BasePart


def dist(point1, point2):
    return math.sqrt((point1['y'] - point2['y']) ** 2 + (point1['x'] - point2['x']) ** 2)


class Lip(BasePart):

    CATEGORIES = ['thin', 'standard', 'thick']
    def __init__(self,**kwargs):
        super(Lip,self).__init__(**kwargs)
        self.mouth_lower_lip_top=self.p_94
        self.mouth_lower_lip_bottom=self.p_85
        self.mouth_left_corner=self.p_76
        self.mouth_upper_lip_top=self.p_79
        self.mouth_upper_lip_bottom=self.p_90
        self.mouth_right_corner=self.p_82
 
    def get_vector(self):
        result=self.angle()
        top,bottom=self.thickness()
        result.append(top)
        result.append(bottom)
        
        normalized= preprocessing.normalize(result).reshape(1,-1)
        return normalized

    def attrs(self):
        return (
        'p_76',
        'p_79',
        'p_82',
        'p_85',
        'p_90',
        'p_94'
        )

    def counteract(self):
        a = getattr(self, 'mouth_lower_lip_bottom')
        b = getattr(self, 'mouth_lower_lip_top')
        c = getattr(self, 'mouth_left_corner')
        d = getattr(self, 'mouth_right_corner')
        e = getattr(self, 'mouth_upper_lip_bottom')
        f = getattr(self, 'mouth_upper_lip_top')

        a['y'] += (c['y'] - b['y'])
        b['y'] = c['y']
        e['y'] = d['y']
        f['y'] -= (e['y'] - d['y'])

        return a, b, c, d, e, f
    def thickness(self):
        width=self.p_82['x']-self.p_76['x']
        top=(self.p_90['y']-self.p_79['y'])/width
        bottom=(self.p_85['y']-self.p_94['y'])/width
        return top,bottom
 
    def angle(self):
        """
        利用余弦定理计算四个唇角
        :return:
        """
        a, b, c, d, e, f = self.counteract()

        l1, l2, l3, l4, l5 = dist(a, b), dist(a, c), dist(a, d), dist(b, c), dist(b, d)
        l6, l7, l8, l9, l10 = dist(e, f), dist(e, c), dist(e, d), dist(f, c), dist(f, d)

        bottom_left_lip_angle = math.degrees(math.acos((l2**2 + l4**2 - l1**2)/(2*l2*l4)))
        bottom_right_lip_angle = math.degrees(math.acos((l3**2 + l5**2 - l1**2)/(2*l3*l5)))
        top_left_lip_angle = math.degrees(math.acos((l7**2 + l9**2 - l6**2)/(2*l7*l9)))
        top_right_lip_angle = math.degrees(math.acos((l8**2 + l10**2 - l6**2)/(2*l8*l10)))

        return [
            (bottom_left_lip_angle + bottom_right_lip_angle) / 2,
            (top_left_lip_angle + top_right_lip_angle) / 2
        ]



