# coding:utf-8
# author:Thierry
from base_part import BasePart
import math

from sklearn import preprocessing
class Nose(BasePart):
    """
    鼻部模型
    """

    CATEGORIES = ['normal', 'wide']
    def __init__(self,**kwargs):
        super(Nose,self).__init__(**kwargs)
        self.left_eye_right_corner=self.p_64
        self.nose_left=self.p_55
        self.right_eye_left_corner=self.p_68
        self.nose_right=self.p_59
    def attrs(self):
        return (
            'p_54',
            'p_55',
            'p_59',
            'p_64',
            'p_68',
        )

    def get_vector(self):
        
        v =  [self._wing_root_ratio(),
                self.wings_angle]
        normalized= preprocessing.normalize(v).reshape(1,-1)
        return normalized

    def dotproduct(v1, v2):
        return sum((a*b) for a, b in zip(v1, v2))

    def length(v):
        return math.sqrt(dotproduct(v, v))

    def wings_angle(self):
        '''
        the angle between the wings
        '''
        v1 = [self.p_55['x'],self.p_55['y']] - [self.p_54['x'],self.p_54['y']] 
        v2 = [self.p_59['x'],self.p_59['y']] - [self.p_54['x'],self.p_54['y']] 
        
        return math.acos(dotproduct(v1, v2) / (length(v1) * length(v2)))

    def _wing_root_ratio(self):
        return self._wing_width() / self._root_width()

    def _root_width(self):
        """
        内眼角的宽度
        """
        return self.left_eye_right_corner['x'] - self.right_eye_left_corner['x']

    def _wing_width(self):
        """
        鼻翼的宽度
        """
        return self.nose_right['x'] - self.nose_left['x']
