import cv2
import skin_detector
import os


def skin_to_white(img_path):
    image = cv2.imread(img_path)
    mask = skin_detector.process(image, thresh=0.5)

    for i in range(0, mask.shape[0]):
        for j in range(0, mask.shape[1]):
            if mask[i, j] == 255:
                image[i, j] = 255
    img_path = img_path.replace('input', 'output')
    cv2.imwrite(img_path, image)


def input_files():
    files = os.listdir('input')
    for file in files:
        img_path = 'input/' + file
        skin_to_white(img_path)
        print(img_path)


if __name__ == '__main__':
    input_files()











#
# image = cv2.imread(img_path)
# mask = skin_detector.process(image)
#
# img_path = img_path.replace('input', 'output')
#
#
#
#
#
# cv2.imwrite('abc.jpg', mask)
#
# mask = cv2.imread('abc.jpg')
#
#
#
# img_add = cv2.addWeighted(image, 0.1, mask, 0.9, 0)
#
# cv2.imwrite(img_path, img_add)
