import requests
import time
import datetime
import pymysql
import random
import pandas as pd
import traceback
from log_settings import *
import logging

auto_reply_url = "http://earth.igengmei.com/api/v1/reply/create"

login_url = "http://earth.igengmei.com/api/account/login_pwd"


def index_first():
    try:
        r1 = requests.get(login_url)
        return r1.cookies.get_dict()
    except:

        logging.error("index_first:%s" % traceback.format_exc())

        return None

def get_majia():

    try:
        data = open("batch user gen")

        list=[]

        for i in data:
            list.append(i.strip('\n').strip(','))

        # time.sleep(random.randint(0, 500))

        maj = random.randint(1,len(list))

        user_id=list[maj-1]

        return user_id

    except:
        logging.error("catch exception,get_majia:%s" % traceback.format_exc())
        return None

def logins():

    try:

        # time.sleep(random.randint(300, 500))

        user_id = get_majia()

        cookies = index_first()

        if cookies is None:
            logging.error("cookies is None!")
            return None

        post_dict = {
            'account_type': 2,
            'pwd': '123456',
            'email': user_id
        }
        response = requests.post(
            url=login_url,
            data=post_dict,
            cookies=cookies
        )

        headers = response.headers

        cook = headers['Set-Cookie'].split(";")

        cook = cook[0].split('=')[1]

        print(response.text, 'url')

        print(cook)

        return {'sessionid': cook}

    except:

        logging.error("catch exception,logins:%s" % traceback.format_exc())
        return None

def reply(cookies_get,id,content):

    try :
        post_dict={
            'topic_id':id,
            'content':content
        }
        response=requests.post(url=auto_reply_url,
                          cookies=cookies_get,
                          data=post_dict)

        print(response.text,'url')
        logging.info("response.text :%s"%(response.text))

    except:
        logging.error("catch exception,reply:%s" % traceback.format_exc())

def time_conv(numtime):

    try:
        now = datetime.datetime.now()
        yes_time  = now -datetime.timedelta(days=numtime)
        yes_time_str=yes_time.strftime('%Y-%m-%d')
        return yes_time_str
    except:
        return None

def get_topic_id(numtime):

    try:
        db = pymysql.connect(host="rm-2ze5k2we69904787l.mysql.rds.aliyuncs.com", user='work', passwd='Gengmei123', db="alpha", port=3306)
        cursor = db.cursor()
        # print("---------")
        cursor.execute("SELECT id FROM topic WHERE create_time LIKE '%%%%%s%%%%' " %numtime)
        data = cursor.fetchall()
        topic_id = list(data)
        logging.info("Database version : %s "%topic_id)
        db.close()
        return topic_id
    except:
        return None

def get_comment():

    data = pd.read_csv("guanshui", sep='\n')
    num = random.randint(0, len(data))
    list_guanshui = []
    for i in data['comment	scene']:
        l = i.split('\t')
        list_guanshui.append(l[0])

    comment = list_guanshui[num-1]
    return comment

if __name__ == "__main__":

    try:

        time_list = [1,2,3,4,5,6,7]

        for i in time_list:

            #time.sleep(random.randint(500,1500))

            numtime = time_conv(i)

            topic_id = get_topic_id(numtime)

            for i in topic_id:

                cook = logins()

                if cook  is not  None:

                    comment = get_comment()

                    reply(cook, i, comment)

    except:

        logging.error("catch exception,main :%s" % traceback.format_exc())
