import requests
import time
import datetime
import pymysql
import random
import pandas as pd
import traceback
from log_settings import *
import logging

auto_click_url = "http://earth.igengmei.com/api/v1/like"
auto_reply_url = "http://earth.igengmei.com/api/v1/reply/create"
auto_follow_url = "http://earth.igengmei.com/api/v1/follow"
login_url = "http://earth.igengmei.com/api/account/login_pwd"

def index_first():
    try:
        r1 = requests.get(login_url)
        return r1.cookies.get_dict()
    except:

        logging.error("index_first:%s" % traceback.format_exc())

        return None

def get_majia():

    try:
        data = open("batch_user_gen")

        list=[]

        for i in data:
            list.append(i.strip('\n').strip(','))

        maj = random.randint(1,len(list))

        user_id=list[maj-1]

        return user_id

    except:
        logging.error("catch exception,get_majia:%s" % traceback.format_exc())
        return None

def get_cookies(user_id):

    try:
        with open("user_session.txt", 'r') as f:
            try:
                data = f.readlines()
            except:
                data = None

        list = []
        for i in data:
            list.append(i.strip('\n').split(","))

        for i in list:

            if user_id == i[0]:

                return (i[1])
    except:

        return None

def login():

    try:
        user_id=get_majia()

        cookies = get_cookies(user_id)

        if cookies is not None:

            return {'sessionid': cookies}

    except:

        logging.error("catch exception,logins:%s" % traceback.format_exc())

        return None

def click(cookies_get, id):

    try:
        post_dict = {
            'type': 0,
            'id': id
        }
        response = requests.post(url=auto_click_url,
                                 cookies=cookies_get,
                                 data=post_dict)

        logging.info("response.text:%s" % response.text)

    except:

        logging.error("catch exception,logins:%s" % traceback.format_exc())

def reply(cookies_get,id,content):

    try:
        post_dict={
            'topic_id':id,
            'content':content
        }
        response=requests.post(url=auto_reply_url,
                      cookies=cookies_get,
                      data=post_dict)

        logging.info("response.text:%s" % response.text)

    except:

        logging.error("catch exception,logins:%s" % traceback.format_exc())

def time_conv():
    try:
        now = datetime.datetime.now()
        yes_time = now - datetime.timedelta(minutes=15)
        print(yes_time)
        return yes_time

    except:
        return None

def get_topic_id(numtime):
    try:
        db = pymysql.connect(host="rm-2ze5k2we69904787l.mysql.rds.aliyuncs.com", user='work', passwd='Gengmei123',
                             db="alpha", port=3306)
        cursor = db.cursor()
        cursor.execute("SELECT id FROM topic WHERE is_online =1 and create_time >= %s" ,(numtime))
        data = cursor.fetchall()
        user_id = list(data)
        logging.info("Database version : %s " % user_id)
        db.close()
        return user_id
    except:
        logging.error("catch exception,get_data:%s" % traceback.format_exc())
        return None

def get_comment():
    try:
        data = pd.read_csv("guanshui", sep='\n')
        num = random.randint(0, len(data))
        list_guanshui = []
        for i in data['comment	scene']:
            l = i.split('\t')
            list_guanshui.append(l[0])

        comment = list_guanshui[num-1]

        return comment

    except:

        return None

if __name__ == "__main__":
    try:

        numtime=time_conv()

        topic_id = get_topic_id(numtime)

        for j in topic_id:

            id = int(j[0])

            click_num = random.randint(1,5)

            for i in range(click_num):

                cookies = login()

                click(cookies, id)

        topic_id = get_topic_id(numtime)

        for j in topic_id:

            id = int(j[0])

            comment_num = random.randint(1, 3)

            for i in range(comment_num):

                cookies= login()

                if cookies is not None:

                    comment = get_comment()

                    reply(cookies, id, comment)
    except:
        logging.error("catch exception,main:%s" % traceback.format_exc())
