import requests
import time
import datetime
import pymysql
import random
import pandas as pd
import traceback
from log_settings import *
import logging
from auto_request import login, reply, click, get_comments, time_conv
from auto_request import host, user, port, db, passwd


def get_topic_id(numtime):
    try:
        pc = pymysql.connect(host=host, user=user, passwd=passwd, db=db, port=port)
        cursor = pc.cursor()
        cursor.execute(
            "SELECT  user_id ,id FROM topic WHERE is_online =1 and create_time >= %s and user_id in (select user_id from user_extra  where is_shadow = 0)",
            (numtime))
        data = cursor.fetchall()
        user_id = list(data)
        logging.info("Database version : %s " % user_id)
        pc.close()
        return user_id
    except:
        logging.error("catch exception,get_data:%s" % traceback.format_exc())
        return None


if __name__ == "__main__":
    try:

        numtime = time_conv(15)

        topic_id = get_topic_id(numtime)

        click_num = random.randint(1, 5)

        for i in range(click_num):

            for j in topic_id:
                id = int(j[0])

                cookies = login()

                time.sleep(random.randint(10, 20))

                click(cookies, id)

            time.sleep(300)

        topic_id = get_topic_id(numtime)

        comment_num = random.randint(0, 3)

        comment_content = get_comments()

        for i in range(comment_num):

            for j in topic_id:

                id = int(j[0])

                cookies = login()

                if cookies is not None:
                    comment = comment_content[i]

                    time.sleep(random.randint(10, 20))

                    reply(cookies, id, comment)

            time.sleep(300)
    except:
        logging.error("catch exception,main:%s" % traceback.format_exc())

# 发帖瞬时：[1 - 5]个马甲点赞
# 1. 用户发帖后，[瞬时]，1-3条评论
