#!/bin/bash

set -e
set -x

SYS=$1
ENV=$2

if [ $# != 2 ]
then
    echo "need tow parameters![gm/alpha prod/dev/test]"
    exit
fi

if [[ "$ENV" == "dev" || "$ENV" == "test" ]];then
    MYSQL_USER="work"
    MYSQL_PASSWORD="Gengmei123"
    MYSQL_HOST="rm-2zeaut61u9sm21m0b.mysql.rds.aliyuncs.com"
    MYSQL_DB="alpha"
    DINGDING='https://oapi.dingtalk.com/robot/send?access_token=47c7de55db1234c6ee0d8f61abae8bc54591f3cef438a41905a0bf4fa33dd6cf'
else
    if [[ "$SYS" == "alpha" ]]
    then
        MYSQL_USER="work"
        MYSQL_PASSWORD="oars152!traipseize738"
        MYSQL_HOST="172.17.40.144"
        MYSQL_DB="alpha"
        DINGDING='https://oapi.dingtalk.com/robot/send?access_token=53686301db86625c308a837fd6d26f56629fc69e693d21b0b12499ab54e74805'
    else
        MYSQL_USER="work"
        MYSQL_PASSWORD="BJQaT9VzDcuPBqkd"
        MYSQL_HOST="172.16.30.143"
        MYSQL_DB="zhengxing"
        DINGDING='https://oapi.dingtalk.com/robot/send?access_token=53686301db86625c308a837fd6d26f56629fc69e693d21b0b12499ab54e74805'
    fi
fi


function red() {
    RED='\033[0;31m'
    NC='\033[0m' # No Color
    printf "${RED} $1 ${NC} \n"
}

function ding() {
	# hostname action
    curl $DINGDING \
       -H 'Content-Type: application/json' \
       -d "{
              'msgtype': 'markdown',
              'markdown': {
                  'title': 'ES同义词全量更新提醒',
                  'text': \"## ES同义词全量更新提醒\n  > **$1 $2** > @ **`date`**\"
              },
              'atMobiles': ['13913000267'],
              'isAtAll': false
       }"
}

ding `hostname` "start to upgrade synonym"


# up to date
su -c 'git pull' gmuser

CUR=`pwd`
FILE="from_db.txt"
DICFILE="from_db.dic"

if [[ -e $FILE ]];then
	rm $FILE
fi

if [[ -e $DICFILE ]];then
	rm $DICFILE
fi

echo "getting synonym from db..."

linestoskip=1
Counter=0

if [[ "$SYS" == "alpha" ]]
then
    SQL="SELECT name,alias FROM community_tag where is_deleted=0 and is_online=1 and alias!='' and name!=''"
    mysql -h $MYSQL_HOST -u $MYSQL_USER -p$MYSQL_PASSWORD $MYSQL_DB -e "$SQL" | while read name alias 
    do
        if [[ $Counter -ge $linestoskip ]]; then
    	    echo "$name"",""$alias" >> $FILE
	    echo "$name" >> $DICFILE
	    echo "$alias" >> $DICFILE
        fi
        Counter=`expr $Counter + 1`
    done
else
    SQL="SELECT GROUP_CONCAT(word SEPARATOR ',') FROM api_wordrelsynonym GROUP BY wordrel_id"
    mysql -h $MYSQL_HOST -u $MYSQL_USER -p$MYSQL_PASSWORD $MYSQL_DB -e "$SQL" | while IFS= read -r ROW
    do
        if [[ $Counter -ge $linestoskip ]]; then
    	    echo "$ROW" >> $FILE
	    array=(${ROW//,/ })
	    for var in ${array[@]}
	    do
	        echo "$var" >> $DICFILE
	    done
        fi
        Counter=`expr $Counter + 1`
    done
fi

cat $FILE > ./synonym.txt
cp ./synonym.txt /srv/apps/elasticsearch/config/analysis/ 

cat $DICFILE > ./synonym.dic
cp ./synonym.dic /srv/apps/elasticsearch/plugins/analysis-ik/config/ik/custom/

rm -rf  /srv/apps/elasticsearch/config/analysis-ik/*
cp -rf ./config /srv/apps/elasticsearch/config/analysis-ik/
cp ./synonym.dic /srv/apps/elasticsearch/config/analysis-ik/config/ik/custom/

# update es
echo "update self `hostname`"

./disable_cluster_routing_allocation.sh

supervisorctl restart elasticsearch
until nc -z $(hostname) 9200;
do
    echo "elasticsearch is starting"
    sleep 2
done

./enable_cluster_routing_allocation.sh
until curl -v "$(hostname):9200/_cluster/health?wait_for_status=green&timeout=10s" | grep 'green';
do
	echo "waiting for elastic cluster status to green"
    sleep 2
done

echo "done"

# clean up
git checkout .
git clean -f -d

ding `hostname` "upgrade synonym successfully!"

exit 0
