#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from django.db import models
import datetime

# duan add,need modify
#from .topic import Topic

class Group(models.Model):
    class Meta:
        verbose_name = u'小组'
        db_table = 'group'

    id = models.IntegerField(verbose_name=u"小组ID",primary_key=True)
    name = models.CharField(verbose_name=u'名称', max_length=100, default='')
    description = models.CharField(verbose_name=u'描述', max_length=200, default='')
    creator_id = models.IntegerField(verbose_name=u'创建者ID')
    #icon = ImgUrlField('图标', max_length=255, img_type=IMG_TYPE.WATERMARK, default='')
    icon = models.CharField(verbose_name=u'图标', max_length=128, default='')
    topic_num = models.IntegerField(verbose_name=u'帖子数', default=0)
    is_online = models.BooleanField(verbose_name=u"是否有效", default=True)
    is_recommend = models.BooleanField(verbose_name=u"是否推荐", default=False)
    create_time = models.DateTimeField(verbose_name=u'创建时间',default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))

    #获取前一天4，5星发帖数
    def get_high_quality_topic_num(self):
        yesterday = datetime.datetime.now()-datetime.timedelta(days=1)
        yesterday_begin_time = "%s-%s-%s 00:00:00" % (yesterday.year, yesterday.month, yesterday.day)
        yesterday_end_time = "%s-%s-%s 23:59:59" % (yesterday.year, yesterday.month, yesterday.day)

        return 0
        #return Topic.objects.filter(content_level__in=("4", "5"), group_id=self.id,create_time__gte=yesterday_begin_time,create_time__lte=yesterday_end_time).count()

    def detail(self):
        result = {
            'id': self.id,
            'name': self.name,
            'description': self.description,
            'creator_id': self.creator_id,
            'icon': self.icon,
            'topic_num': self.topic_num,
            'create_time': self.create_time.timestamp(),
            'update_time': self.update_time.timestamp(),
        }
        return result