#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gm_rpcd.all import bind
import logging
import traceback
import json
from search.utils.topic import TopicUtils
from libs.es import ESPerform
from libs.cache import redis_client


@bind("physical/search/home_recommend")
def home_recommend(user_id=-1,offset=0,size=10):
    """
    :remark:首页推荐，目前只推荐日记
    :return:
    """
    try:
        redis_key = "physical:home_recommend:" + "user_id:" + str(user_id)
        redis_val_dict = redis_client.hgetall(redis_key)
        if len(redis_val_dict) > 0:
            group_topic_ids = json.loads(redis_val_dict["group_topic_ids"])
            not_group_topic_ids = json.loads(redis_val_dict["not_group_topic_ids"])
            group_topic_ids_index = redis_val_dict["group_topic_ids_index"]
            not_group_topic_ids_index = redis_val_dict["not_group_topic_ids_index"]

            if len(group_topic_ids) < (size-1) or len(not_group_topic_ids) < 1:
                if len(group_topic_ids) < (size-1):
                    group_topic_ids_index += 1
                    (new_group_topic_ids, new_not_group_topic_ids) = TopicUtils.get_recommend_topic_ids(user_id, offset, size,
                                                                                                False, group_topic_ids_index, not_group_topic_ids_index)
                    group_topic_ids += new_group_topic_ids
                else:
                    not_group_topic_ids_index += 1
                    (new_group_topic_ids, new_not_group_topic_ids) = TopicUtils.get_recommend_topic_ids(user_id, offset, size,
                                                                                                False, group_topic_ids_index, not_group_topic_ids_index)
                    not_group_topic_ids += new_not_group_topic_ids

            recommend_topic_ids = group_topic_ids[:(size-1)] + not_group_topic_ids[:1]
            redis_hash_dict = {
                "group_topic_ids": group_topic_ids[(size-1):],
                "not_group_topic_ids": not_group_topic_ids[1:],
                "group_topic_ids_index":group_topic_ids_index,
                "not_group_topic_ids_index":not_group_topic_ids_index
            }
            TopicUtils.refresh_redis_hash_data(redis_client,redis_key,redis_hash_dict)

            return {"recommend_topic_ids":recommend_topic_ids}

        else:
            (group_topic_ids,not_group_topic_ids) = TopicUtils.get_recommend_topic_ids(user_id,offset,size,True,0,0)
            recommend_topic_ids = group_topic_ids[:(size - 1)] + not_group_topic_ids[:1]
            redis_hash_dict = {
                "group_topic_ids": group_topic_ids[(size - 1):],
                "not_group_topic_ids": not_group_topic_ids[1:],
                "group_topic_ids_index": 0,
                "not_group_topic_ids_index": 0
            }
            TopicUtils.refresh_redis_hash_data(redis_client, redis_key, redis_hash_dict)
            return {"recommend_topic_ids": recommend_topic_ids}

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_topic_ids": []}

