#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from django.db import models
import datetime


class PickCelebrity(models.Model):
    class Meta:
        verbose_name=u"pick明星"
        db_table = u"pickcelebrity"

    id = models.IntegerField(primary_key=True,verbose_name=u"主键ID")
    celebrity_id = models.IntegerField(verbose_name=u"明星ID")
    pick_id = models.IntegerField(verbose_name=u"榜ID")
    rank = models.IntegerField(verbose_name=u"排名")
    create_time = models.DateTimeField(verbose_name=u'创建时间',default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))
