import pymysql
import random
import traceback
import logging
from vest.request.auto_request import login, time_convs, Urge
from vest.request.auto_request import host, user, passwd
from libs.error import logging_exception


def get_data(numtime):
    try:
        pc = pymysql.connect(host=host, user=user, passwd=passwd, db="physical", port=3306)
        cursor = pc.cursor()
        cursor.execute(
            "select user_id from sl_user_login_status where last_visit_day < '%s' and is_shadow = 0 " % numtime)
        data = cursor.fetchall()
        user_id = list(data)
        logging.info("Database version : %s " % user_id)
        pc.close()
        return user_id
    except:
        logging.error("catch exception,get_data:%s" % traceback.format_exc())
        return None


def auto_lunch_app2():
    try:
        numtime1, numtime2 = time_convs(1, 3)
        user_id = get_data(numtime2)
        for i in user_id and user_id:
            num = random.randint(0, 1)
            if num == 1:
                id = int(i[0])
                cook = login()
                if cook is not None:
                    Urge(cook, id)
    except:
        logging_exception()
        logging.error("catch exception,main:%s" % traceback.format_exc())
