import pymysql
import random
import traceback
import logging
from threading import Thread
from vest.request.auto_request import login, time_conv_hour, click
from vest.request.auto_request import host, user, db, passwd
from libs.error import logging_exception
from libs.timelib import get_rand_time


def get_commnet_id(numtime, numtime2, content_level_low=0, content_level_top=6):
    pc = pymysql.connect(host=host, user=user, passwd=passwd, db=db, port=3306)
    cursor = pc.cursor()

    topic_ids = []

    # 发贴后
    cursor.execute(

        "select t.id from topic t left join user_extra u on t.user_id = u.user_id "
        "where u.is_shadow=0 and t.create_time > '%s' and t.create_time < '%s' and t.is_online=1 "
        "and t.content_level >= %s and t.content_level <=  %s " % (numtime, numtime2, str(content_level_low), str(content_level_top)))

    res = cursor.fetchall()

    for i, in res:
        cursor.execute(

            "SELECT pictorial_id FROM community_pictorial_topic where topic_id=%s limit 1" % i)

        pictorial_id = cursor.fetchall()
        if pictorial_id:
            topic_ids.append((i, pictorial_id[0]))
        else:
            topic_ids.append((i, 0))

    return topic_ids


def batch_handle(auto_click_list):
    for topic_id in auto_click_list:
        try:
            cookies = login()
            if cookies is not None:
                # click(cookies, topic_id)
                click.apply_async(args=(cookies, topic_id), eta=get_rand_time(hourup=1))
        except:
            pass


def auto_click_per_2h_by_post():
    # 发帖触发自动点赞
    auto_click_list = []
    try:
        # 发帖2小时内：[1-3]个点赞
        numtime1, numtime2 = time_conv_hour(0, 2)
        topic_ids = get_commnet_id(numtime2, numtime1, content_level_low=0, content_level_top=6)
        for topic_id in topic_ids:
            click_num = random.randint(1, 3)
            for i in range(click_num):
                auto_click_list.append(topic_id)

    except:
        logging_exception()
        logging.error("catch exception,main:%s" % traceback.format_exc())

    logging.info('auto_click_per_2h_by_post: len %s' % len(auto_click_list))
    print('auto_click_per_2h_by_post: len %s' % len(auto_click_list))

    total = len(auto_click_list)
    limit = (total + 10) // 10
    for start in range(0, total, limit):
        batch = auto_click_list[start:start + limit]
        t = Thread(target=batch_handle, args=[batch])
        t.start()
