#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from pytz import timezone
from datetime import datetime
import traceback
from libs.cache import redis_client
import json
import logging


def tzlc(dt, truncate_to_sec=True):
    if dt is None:
        return None
    if truncate_to_sec:
        dt = dt.replace(microsecond=0)

    if dt.tzinfo is None:
        return timezone(settings.TIME_ZONE).localize(dt)
    else:
        return timezone(settings.TIME_ZONE).normalize(dt)



def get_have_read_topic_id_list(device_id,user_id,query_type):
    try:
        if user_id==-1:
            redis_key = "physical:home_recommend" + ":device_id:" + str(device_id) + ":query_type:" + str(query_type)
        else:
            redis_key = "physical:home_recommend" + ":user_id:" + str(user_id) + ":query_type:" + str(query_type)


        have_read_topic_id_list = list()
        redis_field_list = [b'have_read_topic_list']
        redis_field_val_list = redis_client.hmget(redis_key, redis_field_list)
        if redis_field_val_list[0]:
            have_read_topic_id_list = list(json.loads(redis_field_val_list[0]))

        return have_read_topic_id_list
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return list()