import pymysql
import traceback
import logging
from threading import Thread
from vest.request.auto_request import login, time_conv_hour, get_answer_data, reply_answer, get_majia, \
    set_reply_to_redis, judge_topic_info_get_comment, reply
from vest.request.auto_request import host, user, db, passwd
from libs.error import logging_exception
import random


def get_data(numtime, numtime2):
    try:
        pc = pymysql.connect(host=host, user=user, passwd=passwd, db=db, port=3306)
        cursor = pc.cursor()
        cursor.execute(
            "SELECT id FROM topic WHERE is_online=1  and (create_time >= '%s' and create_time <= '%s' )" % (
                numtime2, numtime))
        res = cursor.fetchall()
        return res and [r for r, in res] or []

    except:
        logging.error("catch exception,get_data:%s" % traceback.format_exc())
        return []


def batch_handle(topic_id_list):
    for topic_id in topic_id_list:
        try:
            cookies = login()
            if cookies is not None:
                comment = judge_topic_info_get_comment(topic_id)
                reply(cookies, topic_id, comment)
        except:
            logging_exception()
            logging.error("catch exception,main:%s" % traceback.format_exc())


def auto_reply_per_2h_to_topic():
    topic_id_list = []
    try:
        numtime1, numtime2 = time_conv_hour(0, 2)
        topic_ids = get_data(numtime1, numtime2)
        for topic_id in topic_ids:
            random_num = random.randint(1, 2)
            for num in range(random_num):
                topic_id_list.append(topic_id)

    except:
        logging_exception()
        logging.error("catch exception,main:%s" % traceback.format_exc())


    logging.info('auto_click_per_2h_by_post: len %s' % len(topic_id_list))
    print('auto_click_per_2h_by_post: len %s' % len(topic_id_list))

    total = len(topic_id_list)
    limit = (total + 10) // 10
    for start in range(0, total, limit):
        batch = topic_id_list[start:start + limit]
        t = Thread(target=batch_handle, args=[batch])
        t.start()