import redis
from django.conf import settings


class RedisWithoutprefixProxy(object):
    _hacked_methods = set([
        'get', 'mget', 'hget', 'hgetall', 'rpop'
    ])

    def __getattribute__(self, name):
        try:
            return super(RedisWithoutprefixProxy, self).__getattribute__(name)
        except AttributeError:
            f = getattr(self.redis,  name)

            if name in RedisWithoutprefixProxy._hacked_methods:
                def wrapper(k, *args, **kwargs):
                    data = f(k, *args, **kwargs)
                    # bug fix for py35, json.loads does accept bytes!
                    if type(data) == bytes:
                        data = data.decode()
                    return data
                return wrapper
            return f

    def __init__(self, conf):
        self.__pool = redis.ConnectionPool(**conf)
        self.redis = redis.StrictRedis(connection_pool=self.__pool)
