import json

from api.views.base_view import BaseView
from alpha_types.venus.enum import REPLY_TYPE
from api.utils.sensitive import Sensitive


class CreateReplyForInner(BaseView):
    """
    内部使用，创建评论回复
    """
    def check_sensitive_content(self, content):
        # 敏感词检测，获取可用的帖子
        check_info = Sensitive.check([content])
        succ = check_info.get(content)
        if not succ:
            return content
        else:
            return

    def post(self, request):
        user_id = request.POST.get('user_id')
        topic_id = request.POST.get('topic_id')
        content = request.POST.get('content', '')
        replied_id = request.POST.get('replied_id')
        reply_type = request.POST.get('type', REPLY_TYPE.PUPPET_REPLY)

        if reply_type not in (REPLY_TYPE.PUPPET_REPLY, REPLY_TYPE.PUPPET_REPLY_ANS):
            if not self.check_sensitive_content(content):
                return
        
        error, data = self.call_rpc('venus/community/reply/for_inner_create', 
                                    user_id=user_id, topic_id=topic_id, content=content,
                                    replied_id=replied_id, reply_type=reply_type)

        if error:
            return self.error(error)

        return self.ok(data=data)
