"""利用gevent并发网络请求"""

import gevent

from gevent import monkey
monkey.patch_socket()


class Task(object):

    def __init__(self, serve, *args, **kwargs):
        self.serve = serve
        self.args = args
        self.kwargs = kwargs


class SpawnTask(object):

    TIMEOUT = 5

    def __init__(self, tasks):
        """tasks：任务列表，其中每个task包含任务以及对应的参数。

        tasks = [
            (get_sensitive, text1, )),
            (get_sensitive, text2, )),
            (get_sensitive, text3, )),
        ]
        """

        self.tasks = tasks
        self.jobs = []

    def run(self):
        """开始任务"""
        # 每个任务的时间在

        self._spawn()
        self._joinall()

    @property
    def result(self):
        return [job.value for job in self.jobs]

    def _spawn(self):

        self.jobs = [
            gevent.spawn(task.serve, *task.args, **task.kwargs)
            for task in self.tasks
        ]

    def _joinall(self):
        gevent.joinall(self.jobs, timeout=self.TIMEOUT)
