
from django.conf import settings

from gm_tracer.tracer import hit_for_sample


def setup_tracer(request):
    # 采样率默认1%
    sample_rate = getattr(settings,'TRACE_SAMPLE_RATE', 1.0)
    sampled = hit_for_sample(sample_rate)
    return {
        'service_name': 'backend',
        'sampled': sampled,
        'span_name': request.path
    }
