#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15

from utils.base import APIView


class StarListView(APIView):
    def get(self, request):
        page = request.GET.get('page', 1)
        limit = request.GET.get('limit', 10)
        filter = self.handle_filter(request.GET.get('filter', ""))
        try:
            data = self.rpc['venus/community/push/get'](offset=page, limit=limit, filters=filter).unwrap()
        except Exception as e:
            data = {
            'total': 200,
            'data': [
                {'id': 1, 'name': '测试1', 'region': '测试2', 'group_nums': 22, 'gender': 1},
                {'id': 2, 'name': '测试1', 'region': '测试2', 'group_nums': 13, 'gender': 1},
                {'id': 3, 'name': '测试1', 'region': '测试2', 'group_nums': 18, 'gender': 0},
            ]
        }

        return data