#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15


from django.conf.urls import url

from .pick import *
from .push import *
from .group import *
from .user import *
from .topic import *
from .star import *

urlpatterns = [
    # user相关
    url(r'user/list$', UserListView.as_view()),

    # group相关
    url(r'group/list$', GroupListView.as_view()),

    # topic相关
    url(r'topic/list$', TopicListView.as_view()),

    # star相关
    url(r'star/list$', StarListView.as_view()),

    # push相关
    url(r'push/list$', PushListView.as_view()),

    # pick相关
    url(r'pick/list$', PickListView.as_view()),
    url(r'pick/update_or_create', UpdateOrCreateView.as_view()),
]