#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15

from utils.base import APIView


class UserListView(APIView):
    def get(self, request):
        page = request.GET.get('page', 1)
        limit = request.GET.get('limit', 10)
        filter = self.handle_filter(request.GET.get('filter', ""))
        try:
            data = self.rpc['venus/community/push/get'](offset=page, limit=limit, filters=filter).unwrap()
        except Exception as e:
            data = {
            'total': 200,
            'data': [
                {"id": 1, 'username': 'alex', 'phone': '12345678912', 'email': 'http://www.baid.com', 'group_nums': 23,
                 'topic_num': 12, 'group_identify': '组长,长老', 'user_identify': '普通用户', 'is_recommend': 1},
                {"id": 2, 'username': 'ttt', 'phone': '12345678912', 'email': 'http://www.baid.com', 'group_nums': 23,
                 'topic_num': 12, 'group_identify': '长老', 'user_identify': '马甲用户', 'is_recommend': 0},
                {"id": 3, 'username': 'xcc', 'phone': '12345678912', 'email': 'http://www.baid.com', 'group_nums': 23,
                 'topic_num': 12, 'group_identify': '精英', 'user_identify': '普通用户', 'is_recommend': 1},
                {"id": 4, 'username': 'aaa', 'phone': '12345678912', 'email': 'http://www.baid.com', 'group_nums': 23,
                 'topic_num': 12, 'group_identify': '高级会有', 'user_identify': '马甲用户', 'is_recommend': 0},
            ]
        }

        return data