#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15

from utils.base import APIView
from utils.logger import error_logger
from alpha_types.venus.error import ERROR


class AdvertiseCreateView(APIView):
    def post(self, request):
        pk_id = request.POST.get('id', '')
        data = {
            "content": request.POST.get('content'),
            "invitees_num": request.POST.get('invitees_num'),
            "unlocks_num": request.POST.get('unlocks_num'),
        }
        if int(data["invitees_num"]) < 1 or int(data["unlocks_num"]) < 1:
            return {
                'message': '数字非法，参数需要大于0',
                'code': 500
            }
        try:
            self.rpc['venus/sun/advertise/create_invite_rule'](pk_id=pk_id, data=data).unwrap()
        except Exception as e:
            if e.error == ERROR.INVITE_RULE_HAD_EXIST:
                return {
                    'message': e.message,
                    'code': 500
                }
            else:
                error_logger.error(u'创建/编辑%s-帖子信息失败%s' % (id, e))
                raise
        return {
            'message': '保存成功',
            'code': 200
        }

    def get(self, request):
        pk_id = request.GET.get('id')
        try:
            data = self.rpc['venus/sun/advertise/get_advertise'](pk_id=pk_id).unwrap()
        except Exception as e:
            error_logger.error(u'文案获取失败%s', e)
            raise
        return data


class AdvertiseListView(APIView):

    def get(self, request):
        try:
            data = self.rpc['venus/sun/advertise/invite_rule']().unwrap()
        except Exception as e:
            error_logger.error(u'获取文案列表失败%s', e)
            raise
        return data
