from utils.base import APIView, get_offset_count
from utils.logger import error_logger


class TopicHomeRecommendList(APIView):

    def get(self, request):

        sort_ = request.GET.get('sort', '-topic_id')
        offset, count = get_offset_count(request)

        try:
            data = self.rpc['venus/sun/operation/topic_recommend/list'](sort_=sort_, offset=offset,
                                                                        count=count).unwrap()
        except Exception as e:
            error_logger.error(u'获取首页推荐帖子列表失败%s', e)
            raise

        return data


class TopicHomeRecommendEdit(APIView):

    def post(self, request):
        
        id_ = request.POST.get('id')
        is_online = request.POST.get("is_online")
        rank = request.POST.get("rank")

        data = {}
        if is_online is not None:
            data["is_online"] = int(is_online)

        if rank is not None:
            data["rank"] = int(rank)

        if not data and not id_:
            return {'message': '参数不全'}

        try:
            self.rpc['venus/sun/operation/topic_recommend/edit'](id_=id_, data=data).unwrap()
        except Exception as e:
            error_logger.error(u'更新失败', e)
            raise

        return {
            'message': '更新成功'
        }


class TopicHomeFixOperation(APIView):

    def get(self, request):

        try:
            pos = request.GET.get("pos", 4)
            data = self.rpc['venus/sun/operation/home_fix/info'](pos=pos).unwrap()
        except Exception as e:
            error_logger.error(u'运营位获取失败%s', e)
            raise

        return {'data': data}

    def post(self, request):

        image = request.POST.get('image')
        protocol = request.POST.get("protocol")
        pos = request.POST.get("pos", 4)

        if not image or not protocol:
            return {'message': '参数不全'}

        try:
            self.rpc['venus/sun/operation/home_fix/edit'](image=image, protocol=protocol, pos=pos).unwrap()
        except Exception as e:
            error_logger.error(u'更新失败', e)
            raise

        return {
            'message': '更新成功'
        }
