import request from '@/utils/request'

export function userSearch(name) {
  return request({
    url: '/api/search/user',
    method: 'get',
    params: { name }
  })
}

export function groupSearch(name) {
  return request({
    url: '/api/search/group',
    method: 'get',
    params: { name }
  })
}

export function countrySearch(name) {
  return request({
    url: '/api/search/country',
    method: 'get',
    params: { name }
  })
}

export function tagSearch(query) {
  return request({
    url: '/api/search/tag',
    method: 'get',
    params: query
  })
}

export function starSearch(name) {
  return request({
    url: '/api/search/celebrity',
    method: 'get',
    params: { name }
  })
}

export function citySearch(name) {
  return request({
    url: '/api/search/city',
    method: 'get',
    params: { name }
  })
}

export function celebritySearch(name) {
  return request({
    url: '/api/search/celebrity',
    method: 'get',
    params: { name }
  })
}

export function topicSearch(name) {
  return request({
    url: '/api/search/topic',
    method: 'get',
    params: { name }
  })
}

export function tagTypeSearch(name) {
  return request({
    url: 'api/search/tagtype',
    method: 'get',
    params: { name }
  })
}
