#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/16

from utils.base import APIView


class AccountList(APIView):
    def get(self, request):
        page = request.GET.get('page', 1)
        limit = request.GET.get('limit', 10)
        filter = self.handle_filter(request.GET.get('filter', ""))
        try:
            data = self.rpc['venus/community/account/get'](offset=page, limit=limit, filters=filter).unwrap()
        except Exception as e:
            # raise e
            data = {
                'total': 1,
                'data': [
                    {
                        'id': 1,
                        'username': 'hahah',
                        'nickname': '哈哈',
                        'phone': '123124312423',
                        'email': 'www.baid.com',
                        'password': '2412412'
                    }
                ]
            }
        return data

    def post(self, request):
        ids = request.POST.get('ids', '').split()
        type = request.POST.get('type', '')
        try:
            self.rpc['venus/community/account/update'](type=type, ids=ids).unwrap()
        except Exception as e:
            raise e
        return {
            "message": "更新成功"
        }


class AccountUpdateOrCreateView(APIView):
    def get(self, request):
        id = request.GET.get('id')
        try:
            data = self.rpc['venus/community/account/detail'](id=id).unwrap()
        except Exception as e:
            # raise e
            data = {
                    'id': 1,
                    'username': 'hahah',
                    'nickname': '哈哈',
                    'phone': '123124312423',
                    'email': 'www.baid.com',
                    'password': '2412412'
            }
        return {'data': data}

    def post(self, request):
        id = request.POST.get('id')
        data = {
            'username': request.POST.get('username'),
            'email': request.POST.get('email'),
            'password': request.POST.get('password'),
            'phone': request.POST.get('phone'),
            'nickname': request.POST.get('nickname'),
        }
        try:
            self.rpc['venus/community/account/create'](id=id, data=data).unwrap()
        except Exception as e:
            raise e
        return {
            'message': '创建成功'
        }


class LoginView(APIView):
    def get(self, request):
        """
        获取用户信息
        :param request:
        :return:
        """
        map = {
            'admin': {
                'id': 1,
                'roles': ['admin'],
                'token': 'admin',
                'introduction': '我是超级管理员',
                'avatar': 'https://wpimg.wallstcn.com/f778738c-e4f8-4870-b634-56703b4acafe.gif',
                'name': 'Super Admin'
            },
            'editor': {
                'id': 2,
                'roles': ['editor'],
                'token': 'editor',
                'introduction': '我是编辑',
                'avatar': 'https://wpimg.wallstcn.com/f778738c-e4f8-4870-b634-56703b4acafe.gif',
                'name': 'Normal Editor'
            }
        }
        token = request.GET.get('token')
        return {
            'data': map[token]
        }

    def post(self, request):
        """
        登陆
        :param request:
        :return:
        """
        username = request.POST.get('username')
        password = request.POST.get('password')

        if username == 'admin' and password == '123123':
            data = {
                'id': 1,
                'roles': ['admin'],
                'token': 'admin',
                'introduction': '我是超级管理员',
                'avatar': 'https://wpimg.wallstcn.com/f778738c-e4f8-4870-b634-56703b4acafe.gif',
                'name': 'Super Admin'
              }
        else:
            data = {
                'id': 2,
                'roles': ['editor'],
                'token': 'editor',
                'introduction': '我是编辑',
                'avatar': 'https://wpimg.wallstcn.com/f778738c-e4f8-4870-b634-56703b4acafe.gif',
                'name': 'Normal Editor'
              }
        return {
            'data': data
        }


class LogoutView(APIView):
    def post(self, request):
        pass


