#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15

from utils.base import APIView


class GroupListView(APIView):
    def get(self, request):
        offset = int(request.GET.get('page', 0))
        count = int(request.GET.get('limit', 10))
        filters = self.handle_filter(request.GET.get('filter', ""))
        try:
            data = self.rpc['venus/community/group/list'](filters=filters, offset=offset, count=count).unwrap()
        except Exception as e:
            raise e
        return data

    def post(self, request):
        ids = request.POST.get('ids', '').split()
        type = request.POST.get('type')
        filters = {}
        if type == 'offline':
            filters['is_online'] = False
        elif type == 'recommend':
            filters['recommend'] = True
        else:
            filters['is_online'] = True
        try:
            self.rpc['venus/community/group/batch/update'](filters=filters, ids=ids).unwrap()
        except Exception as e:
            raise e
        return {
            "message": "更新成功"
        }