#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15

from utils.base import APIView


class PickListView(APIView):
    def get(self, request):
        page = request.GET.get('page', 1)
        limit = request.GET.get('limit', 10)
        filter = self.handle_filter(request.GET.get('filter', ""))
        try:
            data = self.rpc['venus/community/pick/get'](offset=page, limit=limit, filters=filter).unwrap()
        except Exception as e:
            raise e
        return data

    def post(self, request):
        pass


class UpdateOrCreateView(APIView):
    def get(self, request):
        pass

    def post(self, request):
        ids = request.POST.get('ids', '').split()
        type = request.POST.get('type', '')
        try:
            self.rpc['venus/community/pick/offline_pick'](type=type, ids=ids).unwrap()
        except Exception as e:
            raise e
        return {
            "message": "更新成功"
        }