
import Layout from '@/views/layout/Layout'


const AccountRouter = {
  path: '/account',
  component: Layout,
  redirect: '/account/list',
  name: 'Account',
  meta: {
    title: '账号管理',
    icon: 'example'
  },
  children: [
    {
      path: 'list',
      component: () => import('@/views/account/list'),
      name: 'AccountList',
      meta: {title: '账户列表', icon: 'list'}
    },
    {
      path: 'create',
      component: () => import('@/views/account/create'),
      name: 'CreateAccount',
      meta: {title: '创建账户', icon: 'edit'}
    },
    {
      path: 'edit/:id(\\d+)',
      component: () => import('@/views/account/edit'),
      name: 'EditAccount',
      meta: {title: '编辑账户', noCache: true},
      hidden: true
    }
  ]
}

export default AccountRouter
